/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.wavefront;

import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Group;
import javax.vecmath.Point3d;

public abstract class ObjectReader {
    StreamTokenizer st = null;

    public ObjectReader() {
    }

    public ObjectReader(Reader reader) {
        this.init(reader);
    }

    private boolean advance() {
        try {
            this.st.nextToken();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public abstract Group consume();

    public boolean eof() {
        return this.st.ttype == -1;
    }

    public boolean eol() {
        return this.st.ttype == 10;
    }

    public double getDouble() throws NumberFormatException {
        if (!this.advance()) {
            throw new NumberFormatException("expected double value");
        }
        if (this.eol() && !this.advance()) {
            throw new NumberFormatException("expected double value");
        }
        if (this.st.ttype != -2) {
            throw new NumberFormatException("expected double value");
        }
        return this.st.nval;
    }

    public int[] getIntArray() throws NumberFormatException {
        Vector<Integer> vector = new Vector<Integer>();
        while (!this.eol()) {
            if (!(this.advance() && this.st.ttype == -2 || this.eol())) {
                throw new NumberFormatException("expected double value");
            }
            if (this.eol()) continue;
            vector.addElement(new Integer((int)this.st.nval));
        }
        int[] nArray = new int[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            nArray[n] = (Integer)enumeration.nextElement();
            ++n;
        }
        return nArray;
    }

    public String getLine() {
        String string = new String();
        while (!this.eol()) {
            if (!this.advance()) {
                return string;
            }
            if (this.eol()) continue;
            string = this.st.ttype == -3 ? String.valueOf(string) + this.st.sval + " " : String.valueOf(string) + this.st.nval + " ";
        }
        return string;
    }

    public String getWord() {
        if (!this.advance()) {
            return null;
        }
        if (this.st.ttype != -3 && !this.eol()) {
            return null;
        }
        return this.eol() ? null : new String(this.st.sval);
    }

    public void init(Reader reader) {
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(0, 255);
        this.st.whitespaceChars(0, 32);
        this.st.eolIsSignificant(true);
        this.st.commentChar(35);
        this.st.parseNumbers();
    }

    public Point3d readPoint3d() {
        if (!this.advance()) {
            return null;
        }
        if (this.eol() && !this.advance()) {
            return null;
        }
        if (this.st.ttype != -2) {
            System.out.println("readPoint1 syntax error on line " + this.st.lineno());
            return null;
        }
        double d = this.st.nval;
        if (!this.advance()) {
            return null;
        }
        if (this.st.ttype != -2) {
            System.out.println("readPoint2 syntax error on line " + this.st.lineno());
            return null;
        }
        double d2 = this.st.nval;
        if (!this.advance()) {
            return null;
        }
        if (this.st.ttype != -2) {
            System.out.println("readPoint3 syntax error on line " + this.st.lineno());
            return null;
        }
        double d3 = this.st.nval;
        return new Point3d(d, d2, d3);
    }
}

