/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.wavefront;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import ncsa.j3d.loaders.wavefront.AppearanceManager;
import ncsa.j3d.loaders.wavefront.Face;
import ncsa.j3d.loaders.wavefront.FaceManager;
import ncsa.j3d.loaders.wavefront.VertexManager;
import ncsa.j3d.loaders.wavefront.VertexNormalManager;

public class GroupManager
extends Hashtable {
    VertexManager vm;
    VertexNormalManager vnm;
    AppearanceManager am;
    boolean appearanceToGroupName = false;

    public GroupManager(VertexManager vertexManager, VertexNormalManager vertexNormalManager, AppearanceManager appearanceManager) {
        this.vm = vertexManager;
        this.vnm = vertexNormalManager;
        this.am = appearanceManager;
    }

    public void addFace(Face face, String string) {
        FaceManager faceManager;
        if (this.containsKey(string)) {
            faceManager = (FaceManager)this.get(string);
        } else {
            Appearance appearance = this.appearanceToGroupName ? this.am.get(string) : this.am.get();
            faceManager = new FaceManager(this.vm, this.vnm, appearance);
            this.put(string, faceManager);
        }
        faceManager.addFace(face);
    }

    public void changeColor(String string, String string2) {
        if (this.containsKey(string)) {
            FaceManager faceManager = (FaceManager)this.get(string);
            faceManager.changeAppearance(this.am.get(string2));
        }
    }

    public Group getShape() {
        Group group = new Group();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            FaceManager faceManager = (FaceManager)enumeration.nextElement();
            group.addChild(faceManager.getShape());
        }
        return group;
    }

    public void setAppearanceToGroupName() {
        this.appearanceToGroupName = true;
    }
}

