/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.wavefront;

import com.sun.j3d.loaders.Scene;
import java.io.FileReader;
import java.io.Reader;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import ncsa.util.ReaderTokenizer;

public class GenReader
extends ReaderTokenizer {
    String groupname = new String("default");

    public GenReader(Reader reader) throws Exception {
        super(reader);
        this.wordChars(47, 47);
        this.newlineChar(10);
        this.newlineChar(13);
    }

    protected void addedProcessing() {
        this.clearLine();
    }

    void clearLine() {
        while (!this.eol() && this.nextToken() != -103) {
        }
    }

    public Scene consume() {
        try {
            while (this.nextToken() != -103) {
                if (this.ttype != -101) continue;
                this.process();
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(String.valueOf(String.valueOf(numberFormatException)) + " on line " + this.lineno);
            return null;
        }
        return null;
    }

    protected void face(int n) {
        System.out.print(String.valueOf(n) + " ");
    }

    protected void faceEnd() {
        System.out.println(" ");
    }

    protected void faceStart() {
        System.out.print("f ");
    }

    protected void group(String string) {
        System.out.print(String.valueOf(string) + " ");
    }

    protected void groupEnd() {
        System.out.println(" ");
    }

    protected void groupStart() {
        System.out.print("g ");
    }

    void handleFace() throws NumberFormatException {
        this.faceStart();
        while (!this.eol() && this.nextToken() != -103) {
            if (this.ttype != -102) continue;
            this.face((int)this.nval);
            this.processExtendedFace();
        }
        this.faceEnd();
    }

    void handleGroup() {
        this.groupStart();
        while (!this.eol() && this.nextToken() != -103) {
            if (this.ttype != -101) continue;
            this.group(this.sval);
        }
        this.groupEnd();
    }

    void handleLine() throws NumberFormatException {
        this.clearLine();
    }

    void handleMaplib() {
        this.clearLine();
    }

    void handleMtllib() {
        this.clearLine();
    }

    void handleShadow_obj() {
        this.clearLine();
    }

    void handleSmoothingGroup() {
        this.clearLine();
    }

    void handleUsemap() {
        this.clearLine();
    }

    void handleUsemtl() {
        if (!this.eol() && this.nextToken() == -101) {
            this.material(this.sval);
        }
    }

    void handleVertex() {
        this.vertex(this.readPoint());
    }

    void handleVertexNormal() {
        this.vertexNormal(this.readVector());
    }

    void handleVertexTexture() {
        this.clearLine();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("usage: java ncsa.j3d.loaders.wavefront.GenLoader filename");
            return;
        }
        try {
            GenReader genReader = new GenReader(new FileReader(stringArray[0]));
            genReader.consume();
        }
        catch (Exception exception) {
            System.out.println("WavefrontReader.main");
            System.out.println(exception);
        }
    }

    protected void material(String string) {
        System.out.println("usemtl " + string);
    }

    protected void process() {
        if (this.sval.equals("v")) {
            this.handleVertex();
        } else if (this.sval.equals("vn")) {
            this.handleVertexNormal();
        } else if (this.sval.equals("f") || this.sval.equals("fo")) {
            this.handleFace();
        } else if (this.sval.equals("l")) {
            this.handleLine();
        } else if (this.sval.equals("usemtl")) {
            this.handleUsemtl();
        } else if (this.sval.equals("g")) {
            this.handleGroup();
        } else if (this.sval.equals("s")) {
            this.handleSmoothingGroup();
        } else if (this.sval.equals("vt")) {
            this.handleVertexTexture();
        } else if (this.sval.equals("usemap")) {
            this.handleUsemap();
        } else if (this.sval.equals("mtllib")) {
            this.handleMtllib();
        } else if (this.sval.equals("maplib")) {
            this.handleMaplib();
        } else if (this.sval.equals("shadow_obj")) {
            this.handleShadow_obj();
        } else {
            this.addedProcessing();
        }
    }

    protected void processExtendedFace() {
        if (this.eol()) {
            return;
        }
        if (this.nextToken() != -101) {
            this.pushBack();
        }
    }

    protected Point3d readPoint() {
        Point3d point3d = new Point3d();
        if (this.nextToken() != -102) {
            return null;
        }
        point3d.x = this.nval;
        if (this.nextToken() != -102) {
            return null;
        }
        point3d.y = this.nval;
        if (this.nextToken() != -102) {
            return null;
        }
        point3d.z = this.nval;
        return point3d;
    }

    protected Vector3d readVector() {
        Vector3d vector3d = new Vector3d();
        if (this.nextToken() != -102) {
            return null;
        }
        vector3d.x = this.nval;
        if (this.nextToken() != -102) {
            return null;
        }
        vector3d.y = this.nval;
        if (this.nextToken() != -102) {
            return null;
        }
        vector3d.z = this.nval;
        return vector3d;
    }

    protected void vertex(Point3d point3d) {
        if (point3d != null) {
            System.out.println("v " + point3d.x + " " + point3d.y + " " + point3d.z);
        } else {
            System.out.println("v ERROR: could not read the point");
        }
    }

    protected void vertexNormal(Vector3d vector3d) {
        if (vector3d != null) {
            System.out.println("vn " + vector3d.x + " " + vector3d.y + " " + vector3d.z);
        } else {
            System.out.println("v Error: could not read the normal");
        }
    }
}

