/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.wavefront;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;
import ncsa.j3d.loaders.wavefront.AppearanceManager;
import ncsa.j3d.loaders.wavefront.ObjectReader;

public class AppearanceReader
extends ObjectReader {
    AppearanceManager am = new AppearanceManager();
    String filename;
    DataInputStream dis;
    String name;
    Appearance a;
    Material m;

    public AppearanceReader(String string) throws FileNotFoundException {
        super(new BufferedReader(new FileReader(AppearanceReader.figureMaterialFilename(string))));
        this.filename = AppearanceReader.figureMaterialFilename(string);
    }

    public AppearanceReader(URL uRL) throws FileNotFoundException {
        try {
            this.init(new BufferedReader(new InputStreamReader(uRL.openStream())));
        }
        catch (Exception exception) {
            System.out.println("Couldn't open stream to " + uRL);
            throw new FileNotFoundException();
        }
    }

    public Group consume() {
        return null;
    }

    public AppearanceManager create() {
        try {
            while (!this.eof()) {
                String string = this.getWord();
                if (string == null) continue;
                if (string.equals("newmtl")) {
                    this.handleNewMaterial();
                    continue;
                }
                if (string.equals("Ka")) {
                    this.handleKa();
                    continue;
                }
                if (string.equals("Kd")) {
                    this.handleKd();
                    continue;
                }
                if (string.equals("Ks")) {
                    this.handleKs();
                    continue;
                }
                if (string.equals("illum")) {
                    this.handleIllum();
                    continue;
                }
                if (!string.equals("Ns")) continue;
                this.handleNs();
            }
        }
        catch (IOException iOException) {
            System.out.println("AppearanceReader! -> ");
            System.out.println(iOException);
        }
        this.forceOldMaterial();
        return this.am;
    }

    static String figureMaterialFilename(String string) {
        String string2;
        if (string.endsWith(".mtl")) {
            return new String(string);
        }
        if (string.endsWith(".obj")) {
            string2 = string.substring(0, string.indexOf(".obj"));
            string2 = String.valueOf(string2) + ".mtl";
        } else {
            string2 = new String(string);
        }
        return string2;
    }

    void forceOldMaterial() {
        if (this.a != null && this.m != null) {
            this.a.setMaterial(this.m);
            this.am.add(this.name, this.a);
        }
        this.a = new Appearance();
        this.m = new Material();
        this.m.setShininess(128.0f);
        this.m.setLightingEnable(true);
    }

    void handleIllum() throws IOException {
        String string = this.getLine();
    }

    void handleKa() throws IOException {
        Color3f color3f = new Color3f((float)this.getDouble(), (float)this.getDouble(), (float)this.getDouble());
        this.m.setAmbientColor(color3f);
    }

    void handleKd() throws IOException {
        Color3f color3f = new Color3f((float)this.getDouble(), (float)this.getDouble(), (float)this.getDouble());
        this.m.setDiffuseColor(color3f);
    }

    void handleKs() throws IOException {
        Color3f color3f = new Color3f((float)this.getDouble(), (float)this.getDouble(), (float)this.getDouble());
        this.m.setSpecularColor(color3f);
    }

    void handleNewMaterial() throws IOException {
        this.forceOldMaterial();
        this.name = this.getWord();
    }

    void handleNs() throws IOException {
        String string = this.getLine();
    }
}

