/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.vtk.FileReader;
import ncsa.j3d.loaders.vtk.POINTS;
import ncsa.util.ReaderTokenizer;

public class VTKLoader {
    public static final int ASCII = 0;
    public static final int BINARY = 1;
    public static final int BIG = 0;
    public static final int LITTLE = 1;
    public static final int BIG_ENDIAN = 0;
    public static final int LITTLE_ENDIAN = 1;
    public static boolean debug = false;
    int filetype = 0;
    public static int endian = 1;
    private static BranchGroup bg;
    private ReaderTokenizer reader;
    static String pckg;
    static POINTS points;
    static int pointCount;
    static Vector3f[] normals;
    static Color4f[] colors;
    static Appearance appearance;

    static {
        pckg = "ncsa.j3d.loaders.vtk";
        points = new POINTS();
        pointCount = 0;
        normals = null;
        colors = null;
    }

    void PrintError(String string) {
        System.out.println("File error, line #" + this.reader.lineno() + ": " + string);
    }

    public static void addNode(Node node) {
        bg.addChild(node);
    }

    public static Appearance getAppearance() {
        return appearance;
    }

    public static Color4f[] getColors() {
        return colors;
    }

    public static Vector3f[] getNormals() {
        return normals;
    }

    public static String getPckg() {
        return pckg;
    }

    public static int getPointCount() {
        return pointCount;
    }

    public static Point3f[] getPoints() {
        return points.getPoints();
    }

    public BranchGroup load(Reader reader, int n) throws IOException {
        endian = n;
        bg = new BranchGroup();
        bg.setCapability(3);
        TransformGroup transformGroup = new TransformGroup();
        bg.addChild((Node)transformGroup);
        points = new POINTS();
        pointCount = 0;
        normals = null;
        colors = null;
        Material material = new Material();
        material.setDiffuseColor(0.3f, 0.3f, 0.3f);
        material.setAmbientColor(0.7f, 0.7f, 0.7f);
        appearance = new Appearance();
        appearance.setMaterial(material);
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = bufferedReader.readLine();
        if (!string.substring(0, 14).equalsIgnoreCase("# vtk DataFile")) {
            System.out.println("Incorrect VTK data file header.");
            return new BranchGroup();
        }
        if (!string.equalsIgnoreCase("# vtk DataFile Version 2.0") && !string.equalsIgnoreCase("# vtk DataFile Version 1.0") && debug) {
            System.out.println("Untested VTK file version (not 1.0 or 2.0).");
            System.out.println("Processing will continue.");
        }
        String string2 = bufferedReader.readLine();
        if (debug) {
            System.out.println("");
            System.out.println("READING A NEW VTK FILE");
            System.out.println("File comment: " + string2);
            System.out.println(string);
        }
        this.reader = new ReaderTokenizer(bufferedReader);
        this.reader.nextToken();
        String string3 = this.reader.sval;
        if (string3.equalsIgnoreCase("ASCII")) {
            this.filetype = 0;
        } else if (string3.equalsIgnoreCase("BINARY")) {
            this.filetype = 1;
        } else {
            this.PrintError("Expected keywords BINARY or ASCII not found.");
            return new BranchGroup();
        }
        String string4 = null;
        String string5 = null;
        Vector<FileReader> vector = new Vector<FileReader>();
        this.reader.nextToken();
        while (this.reader.ttype != -103) {
            try {
                if (this.reader.ttype != -101) {
                    this.PrintError("Expecting a keyword string.");
                    return new BranchGroup();
                }
                string5 = this.reader.sval;
                if (!string5.equalsIgnoreCase("DATASET")) {
                    if (debug) {
                        System.out.println("VTKLoader: reading " + string5);
                    }
                    string4 = new String(String.valueOf(pckg) + "." + string5);
                    vector.add((FileReader)Class.forName(string4).newInstance());
                    if (!((FileReader)vector.lastElement()).read(this.reader, this.filetype)) {
                        return new BranchGroup();
                    }
                }
                this.reader.nextToken();
            }
            catch (Exception exception) {
                this.PrintError("Error in type: " + string5);
                System.out.println("   (" + exception + ")");
                return new BranchGroup();
            }
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string6 = vector.elementAt(n2).getClass().getName();
            String string7 = string6.substring(pckg.length() + 1);
            if (debug && !string7.equalsIgnoreCase("POINT_DATA")) {
                System.out.println("VTKLoader: adding " + string7);
            }
            ((FileReader)vector.elementAt(n2)).addShape();
            ++n2;
        }
        if (debug) {
            System.out.println("VTKLoader: Done.");
        }
        return bg;
    }

    public static void main(String[] stringArray) {
        try {
            java.io.FileReader fileReader = new java.io.FileReader(stringArray[0]);
            VTKLoader vTKLoader = new VTKLoader();
            BranchGroup branchGroup = vTKLoader.load(fileReader, 1);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static void setColors(Color4f[] color4fArray) {
        colors = color4fArray;
    }

    public static void setNormals(Vector3f[] vector3fArray) {
        normals = vector3fArray;
    }

    public static void setPointCount(int n) {
        pointCount = n;
    }

    public static void setPoints(Point3f[] point3fArray) {
        points.setPoints(point3fArray);
        pointCount = point3fArray.length;
    }
}

