/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import javax.vecmath.Point3f;
import ncsa.j3d.loaders.vtk.CharReader;
import ncsa.j3d.loaders.vtk.DataTypeReader;
import ncsa.j3d.loaders.vtk.FileReader;
import ncsa.j3d.loaders.vtk.FloatReader;
import ncsa.j3d.loaders.vtk.GRID;
import ncsa.j3d.loaders.vtk.IntReader;
import ncsa.j3d.loaders.vtk.LINES;
import ncsa.j3d.loaders.vtk.VTKLoader;
import ncsa.util.ReaderTokenizer;

public class RECTILINEAR_GRID
extends GRID
implements FileReader {
    int dimX = 0;
    int dimY = 0;
    int dimZ = 0;

    public void addShape() {
        LINES lINES = new LINES();
        lINES.setLines(this.connectPoints(this.dimX, this.dimY, this.dimZ));
        lINES.addShape();
    }

    public boolean read(ReaderTokenizer readerTokenizer, int n) {
        IntReader intReader = new IntReader(readerTokenizer);
        FloatReader floatReader = new FloatReader(readerTokenizer);
        readerTokenizer.nextToken();
        if (!readerTokenizer.sval.equalsIgnoreCase("DIMENSIONS")) {
            System.out.println("RECTILINEAR_GRID: expecting DIMENSIONS keyword.");
            return false;
        }
        this.dimX = intReader.read();
        this.dimY = intReader.read();
        this.dimZ = intReader.read();
        float[] fArray = new float[this.dimX];
        float[] fArray2 = new float[this.dimY];
        float[] fArray3 = new float[this.dimZ];
        readerTokenizer.nextToken();
        if (readerTokenizer.ttype != -101 || !readerTokenizer.sval.equalsIgnoreCase("X_COORDINATES")) {
            System.out.println("RECTILINEAR_GRID: expecting X_COORDINATES keyword.");
            return false;
        }
        int n2 = intReader.read();
        readerTokenizer.nextToken();
        String string = new String(readerTokenizer.sval);
        CharReader charReader = new CharReader(readerTokenizer);
        if (n == 1) {
            charReader.readBinary();
        }
        if (string.equalsIgnoreCase("bit") && n == 1) {
            System.out.println("RECTILINEAR_GRID: cannot read BIT datatype in binary files.");
            return false;
        }
        DataTypeReader dataTypeReader = new DataTypeReader(readerTokenizer, string, n);
        int n3 = 0;
        while (n3 < this.dimX) {
            fArray[n3] = dataTypeReader.read();
            ++n3;
        }
        readerTokenizer.nextToken();
        if (readerTokenizer.ttype != -101 || !readerTokenizer.sval.equalsIgnoreCase("Y_COORDINATES")) {
            System.out.println("RECTILINEAR_GRID; expecting Y_COORDINATES keyword.");
            return false;
        }
        int n4 = intReader.read();
        readerTokenizer.nextToken();
        String string2 = new String(readerTokenizer.sval);
        if (n == 1) {
            charReader.readBinary();
        }
        if (string2.equalsIgnoreCase("bit") && n == 1) {
            System.out.println("RECTILINEAR_GRID: cannot read BIT datatype in binary files.");
            return false;
        }
        dataTypeReader = new DataTypeReader(readerTokenizer, string2, n);
        n4 = 0;
        while (n4 < this.dimY) {
            fArray2[n4] = dataTypeReader.read();
            ++n4;
        }
        readerTokenizer.nextToken();
        if (readerTokenizer.ttype != -101 || !readerTokenizer.sval.equalsIgnoreCase("Z_COORDINATES")) {
            System.out.println("RECTILINEAR_GRID; expecting Z_COORDINATES keyword.");
            return false;
        }
        int n5 = intReader.read();
        readerTokenizer.nextToken();
        String string3 = new String(readerTokenizer.sval);
        if (n == 1) {
            charReader.readBinary();
        }
        if (string3.equalsIgnoreCase("bit") && n == 1) {
            System.out.println("RECTILINEAR_GRID: cannot read BIT datatype in binary files.");
            return false;
        }
        dataTypeReader = new DataTypeReader(readerTokenizer, string3, n);
        n5 = 0;
        while (n5 < this.dimZ) {
            fArray3[n5] = dataTypeReader.read();
            ++n5;
        }
        Point3f[] point3fArray = new Point3f[this.dimX * this.dimY * this.dimZ];
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.dimZ) {
            int n8 = 0;
            while (n8 < this.dimY) {
                int n9 = 0;
                while (n9 < this.dimX) {
                    point3fArray[n6] = new Point3f(fArray[n9], fArray2[n8], fArray3[n7]);
                    ++n6;
                    ++n9;
                }
                ++n8;
            }
            ++n7;
        }
        VTKLoader.setPoints(point3fArray);
        return true;
    }
}

