/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Triangulator;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.vtk.CharReader;
import ncsa.j3d.loaders.vtk.FileReader;
import ncsa.j3d.loaders.vtk.IntReader;
import ncsa.j3d.loaders.vtk.VTKLoader;
import ncsa.util.ReaderTokenizer;

public class POLYGONS
implements FileReader {
    int[][] polygons;

    public void addShape() {
        Triangulator triangulator;
        int n;
        Point3f[] point3fArray = VTKLoader.getPoints();
        int[] nArray = new int[this.polygons.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.polygons.length) {
            n = 0;
            while (n < this.polygons[n3].length) {
                ++n2;
                ++n;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        n2 = 0;
        n3 = 0;
        while (n3 < this.polygons.length) {
            nArray[n3] = this.polygons[n3].length;
            n = 0;
            while (n < this.polygons[n3].length) {
                nArray2[n2] = this.polygons[n3][n];
                ++n2;
                ++n;
            }
            ++n3;
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setCoordinateIndices(nArray2);
        geometryInfo.setStripCounts(nArray);
        Color4f[] color4fArray = VTKLoader.getColors();
        if (color4fArray != null && color4fArray.length == VTKLoader.getPointCount()) {
            geometryInfo.setColors(color4fArray);
            geometryInfo.setColorIndices(nArray2);
        }
        Vector3f[] vector3fArray = null;
        vector3fArray = VTKLoader.getNormals();
        if (vector3fArray != null) {
            geometryInfo.setNormals(vector3fArray);
            geometryInfo.setNormalIndices(nArray2);
            triangulator = new Triangulator();
            triangulator.triangulate(geometryInfo);
        } else {
            triangulator = new Triangulator();
            triangulator.triangulate(geometryInfo);
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.generateNormals(geometryInfo);
        }
        triangulator = new Shape3D((Geometry)geometryInfo.getGeometryArray(), VTKLoader.getAppearance());
        VTKLoader.addNode((Node)triangulator);
    }

    public boolean read(ReaderTokenizer readerTokenizer, int n) {
        IntReader intReader = new IntReader(readerTokenizer);
        int n2 = intReader.read();
        this.polygons = new int[n2][];
        int n3 = intReader.read();
        CharReader charReader = new CharReader(readerTokenizer);
        if (n == 1) {
            charReader.readBinary();
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5 = n == 0 ? intReader.read() : intReader.readBinary();
            this.polygons[n4] = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                this.polygons[n4][n6] = n == 0 ? intReader.read() : intReader.readBinary();
                ++n6;
            }
            ++n4;
        }
        return true;
    }

    void setPolygons(int[][] nArray) {
        this.polygons = nArray;
    }
}

