/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import javax.vecmath.Point3f;
import ncsa.j3d.loaders.vtk.CharReader;
import ncsa.j3d.loaders.vtk.DataTypeReader;
import ncsa.j3d.loaders.vtk.IntReader;
import ncsa.j3d.loaders.vtk.VTKLoader;
import ncsa.util.ReaderTokenizer;

public class POINTS {
    Point3f[] points;

    void PrintError(ReaderTokenizer readerTokenizer, String string) {
        System.out.println("File error, line #" + readerTokenizer.lineno() + ": " + string);
    }

    public Point3f[] getPoints() {
        return this.points;
    }

    public boolean read(ReaderTokenizer readerTokenizer, int n) {
        IntReader intReader = new IntReader(readerTokenizer);
        int n2 = intReader.read();
        VTKLoader.setPointCount(n2);
        this.points = new Point3f[n2];
        readerTokenizer.nextToken();
        if (readerTokenizer.ttype != -101) {
            this.PrintError(readerTokenizer, "POINTS: Expecting a data type.");
            return false;
        }
        String string = readerTokenizer.sval;
        CharReader charReader = new CharReader(readerTokenizer);
        if (n == 1) {
            charReader.readBinary();
        }
        if (string.equalsIgnoreCase("bit") && n == 1) {
            this.PrintError(readerTokenizer, "POINTS: Cannot read BIT datatype in BINARY files.");
            return false;
        }
        DataTypeReader dataTypeReader = new DataTypeReader(readerTokenizer, string, n);
        int n3 = 0;
        while (n3 < n2) {
            this.points[n3] = new Point3f(dataTypeReader.read(), dataTypeReader.read(), dataTypeReader.read());
            ++n3;
        }
        VTKLoader.setPoints(this.points);
        return true;
    }

    public void setPoints(Point3f[] point3fArray) {
        this.points = point3fArray;
    }
}

