/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import ncsa.j3d.loaders.vtk.VTKLoader;
import ncsa.util.ReaderTokenizer;

public class FloatReader {
    ReaderTokenizer reader = null;

    public FloatReader(ReaderTokenizer readerTokenizer) {
        this.reader = readerTokenizer;
    }

    void PrintError(String string) {
        System.out.println("File error, line #" + this.reader.lineno() + ": " + string);
    }

    public float read() {
        int n = this.reader.nextToken();
        if (n != -102) {
            this.PrintError("Expecting float value.");
            return 0.0f;
        }
        return new Double(this.reader.nval).floatValue();
    }

    public float readBinary() {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            char c;
            if (VTKLoader.endian == 1) {
                c = this.reader.read();
                n += c << 8 * n2;
            } else {
                c = this.reader.read();
                n += c << 8 * (3 - n2);
            }
            ++n2;
        }
        return Float.intBitsToFloat(n);
    }
}

