/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import ncsa.j3d.loaders.vtk.VTKLoader;
import ncsa.util.ReaderTokenizer;

public class DoubleReader {
    ReaderTokenizer reader = null;

    public DoubleReader(ReaderTokenizer readerTokenizer) {
        this.reader = readerTokenizer;
    }

    void PrintError(String string) {
        System.out.println("File error, line #" + this.reader.lineno() + ": " + string);
    }

    public double read() {
        int n = this.reader.nextToken();
        if (n != -102) {
            this.PrintError("Expecting a double floating point value.");
            return 0.0;
        }
        return this.reader.nval;
    }

    public double readBinary() {
        long l = 0L;
        int n = 0;
        while (n < 8) {
            l = VTKLoader.endian == 1 ? (l += (long)(this.reader.read() << 8 * n)) : (l += (long)(this.reader.read() << 8 * (7 - n)));
            ++n;
        }
        return Double.longBitsToDouble(l);
    }
}

