/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import ncsa.j3d.loaders.vtk.CharReader;
import ncsa.j3d.loaders.vtk.DoubleReader;
import ncsa.j3d.loaders.vtk.FloatReader;
import ncsa.j3d.loaders.vtk.IntReader;
import ncsa.j3d.loaders.vtk.ShortReader;
import ncsa.util.ReaderTokenizer;

public class DataTypeReader {
    ReaderTokenizer reader = null;
    String dataType;
    int fileType;

    public DataTypeReader(ReaderTokenizer readerTokenizer, String string, int n) {
        this.reader = readerTokenizer;
        this.dataType = string;
        this.fileType = n;
    }

    public float read() {
        if (this.dataType.equalsIgnoreCase("bit")) {
            IntReader intReader = new IntReader(this.reader);
            if (this.fileType == 0) {
                return intReader.read();
            }
            System.out.println("Cannot read BIT datatype in binary files.");
            return 0.0f;
        }
        if (this.dataType.equalsIgnoreCase("short")) {
            ShortReader shortReader = new ShortReader(this.reader);
            if (this.fileType == 0) {
                return shortReader.read();
            }
            return shortReader.readBinary();
        }
        if (this.dataType.equalsIgnoreCase("short")) {
            IntReader intReader = new IntReader(this.reader);
            if (this.fileType == 0) {
                return intReader.read();
            }
            return intReader.readBinary();
        }
        if (this.dataType.equalsIgnoreCase("unsigned_char")) {
            CharReader charReader = new CharReader(this.reader);
            if (this.fileType == 0) {
                return charReader.read();
            }
            return charReader.readBinary();
        }
        if (this.dataType.equalsIgnoreCase("float")) {
            FloatReader floatReader = new FloatReader(this.reader);
            if (this.fileType == 0) {
                return floatReader.read();
            }
            return floatReader.readBinary();
        }
        if (this.dataType.equalsIgnoreCase("double")) {
            DoubleReader doubleReader = new DoubleReader(this.reader);
            if (this.fileType == 0) {
                return (float)doubleReader.read();
            }
            return (float)doubleReader.readBinary();
        }
        System.out.println("Unrecognized data type: " + this.dataType + ", line #" + this.reader.lineno());
        return 0.0f;
    }
}

