/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vtk;

import javax.vecmath.Point3f;
import ncsa.j3d.loaders.vtk.CharReader;
import ncsa.j3d.loaders.vtk.HEXAHEDRONS;
import ncsa.j3d.loaders.vtk.IntReader;
import ncsa.j3d.loaders.vtk.LINES;
import ncsa.j3d.loaders.vtk.POLYGONS;
import ncsa.j3d.loaders.vtk.TETRAS;
import ncsa.j3d.loaders.vtk.TRIANGLE_STRIPS;
import ncsa.j3d.loaders.vtk.VERTICES;
import ncsa.j3d.loaders.vtk.VOXELS;
import ncsa.j3d.loaders.vtk.VTKLoader;
import ncsa.util.ReaderTokenizer;

public class CELL_TYPES {
    int[] cellTypes;
    static final int VTK_VERTEX = 1;
    static final int VTK_POLY_VERTEX = 2;
    static final int VTK_LINE = 3;
    static final int VTK_POLY_LINE = 4;
    static final int VTK_TRIANGLE = 5;
    static final int VTK_TRIANGLE_STRIP = 6;
    static final int VTK_POLYGON = 7;
    static final int VTK_PIXEL = 8;
    static final int VTK_QUAD = 9;
    static final int VTK_TETRA = 10;
    static final int VTK_VOXEL = 11;
    static final int VTK_HEXAHEDRON = 12;

    public void addShape(int[][] nArray) {
        Point3f[] point3fArray = VTKLoader.getPoints();
        int[][] nArray2 = new int[1][];
        int n = 0;
        while (n < nArray.length) {
            nArray2[0] = nArray[n];
            int n2 = nArray[n].length;
            switch (this.cellTypes[n]) {
                case 1: 
                case 2: {
                    VERTICES vERTICES = new VERTICES();
                    vERTICES.setVertices(nArray2[0]);
                    vERTICES.addShape();
                    break;
                }
                case 3: {
                    int[][] nArray3 = new int[n2 / 2][2];
                    int n3 = 0;
                    int n4 = 0;
                    while (n3 < n2) {
                        nArray3[n4][0] = nArray2[0][n3];
                        nArray3[n4][1] = nArray2[0][n3 + 1];
                        n3 += 2;
                        ++n4;
                    }
                    LINES lINES = new LINES();
                    lINES.setLines(nArray3);
                    lINES.addShape();
                    break;
                }
                case 4: {
                    LINES lINES = new LINES();
                    lINES.setLines(nArray2);
                    lINES.addShape();
                    break;
                }
                case 5: {
                    int[][] nArray4 = new int[n2 / 3][3];
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < n2) {
                        nArray4[n6][0] = nArray2[0][n5];
                        nArray4[n6][1] = nArray2[0][n5 + 1];
                        nArray4[n6][2] = nArray2[0][n5 + 2];
                        n5 += 3;
                        ++n6;
                    }
                    POLYGONS pOLYGONS = new POLYGONS();
                    pOLYGONS.setPolygons(nArray4);
                    pOLYGONS.addShape();
                    break;
                }
                case 6: {
                    TRIANGLE_STRIPS tRIANGLE_STRIPS = new TRIANGLE_STRIPS();
                    tRIANGLE_STRIPS.setTriangles(nArray2);
                    tRIANGLE_STRIPS.addShape();
                    break;
                }
                case 7: {
                    POLYGONS pOLYGONS = new POLYGONS();
                    pOLYGONS.setPolygons(nArray2);
                    pOLYGONS.addShape();
                    break;
                }
                case 9: {
                    int[][] nArray5 = new int[n2 / 4][4];
                    int n7 = 0;
                    int n8 = 0;
                    while (n7 < n2) {
                        nArray5[n8][0] = nArray2[0][n7];
                        nArray5[n8][1] = nArray2[0][n7 + 1];
                        nArray5[n8][2] = nArray2[0][n7 + 2];
                        nArray5[n8][3] = nArray2[0][n7 + 3];
                        n7 += 4;
                        ++n8;
                    }
                    POLYGONS pOLYGONS = new POLYGONS();
                    pOLYGONS.setPolygons(nArray5);
                    pOLYGONS.addShape();
                    break;
                }
                case 8: {
                    int[][] nArray6 = new int[n2 / 4][4];
                    int n9 = 0;
                    int n10 = 0;
                    while (n9 < n2) {
                        nArray6[n10][0] = nArray2[0][n9];
                        nArray6[n10][1] = nArray2[0][n9 + 1];
                        nArray6[n10][2] = nArray2[0][n9 + 3];
                        nArray6[n10][3] = nArray2[0][n9 + 2];
                        n9 += 4;
                        ++n10;
                    }
                    POLYGONS pOLYGONS = new POLYGONS();
                    pOLYGONS.setPolygons(nArray6);
                    pOLYGONS.addShape();
                    break;
                }
                case 10: {
                    int[][] nArray7 = new int[n2 / 4][4];
                    int n11 = 0;
                    int n12 = 0;
                    while (n11 < n2) {
                        nArray7[n12][0] = nArray2[0][n11];
                        nArray7[n12][1] = nArray2[0][n11 + 1];
                        nArray7[n12][2] = nArray2[0][n11 + 2];
                        nArray7[n12][3] = nArray2[0][n11 + 3];
                        n11 += 4;
                        ++n12;
                    }
                    TETRAS tETRAS = new TETRAS();
                    tETRAS.setTetras(nArray7);
                    tETRAS.addShape();
                    break;
                }
                case 12: {
                    int[][] nArray8 = new int[n2 / 8][8];
                    int n13 = 0;
                    int n14 = 0;
                    while (n13 < n2) {
                        nArray8[n14][0] = nArray2[0][n13];
                        nArray8[n14][1] = nArray2[0][n13 + 1];
                        nArray8[n14][2] = nArray2[0][n13 + 2];
                        nArray8[n14][3] = nArray2[0][n13 + 3];
                        nArray8[n14][4] = nArray2[0][n13 + 4];
                        nArray8[n14][5] = nArray2[0][n13 + 5];
                        nArray8[n14][6] = nArray2[0][n13 + 6];
                        nArray8[n14][7] = nArray2[0][n13 + 7];
                        n13 += 8;
                        ++n14;
                    }
                    HEXAHEDRONS hEXAHEDRONS = new HEXAHEDRONS();
                    hEXAHEDRONS.setHexahedrons(nArray8);
                    hEXAHEDRONS.addShape();
                    break;
                }
                case 11: {
                    int[][] nArray9 = new int[n2 / 8][8];
                    int n15 = 0;
                    int n16 = 0;
                    while (n15 < n2) {
                        nArray9[n16][0] = nArray2[0][n15];
                        nArray9[n16][1] = nArray2[0][n15 + 1];
                        nArray9[n16][2] = nArray2[0][n15 + 2];
                        nArray9[n16][3] = nArray2[0][n15 + 3];
                        nArray9[n16][4] = nArray2[0][n15 + 4];
                        nArray9[n16][5] = nArray2[0][n15 + 5];
                        nArray9[n16][6] = nArray2[0][n15 + 6];
                        nArray9[n16][7] = nArray2[0][n15 + 7];
                        n15 += 8;
                        ++n16;
                    }
                    VOXELS vOXELS = new VOXELS();
                    vOXELS.setVoxels(nArray9);
                    vOXELS.addShape();
                    break;
                }
            }
            ++n;
        }
    }

    public boolean read(ReaderTokenizer readerTokenizer, int n) {
        IntReader intReader = new IntReader(readerTokenizer);
        int n2 = intReader.read();
        this.cellTypes = new int[n2];
        CharReader charReader = new CharReader(readerTokenizer);
        if (n == 1) {
            charReader.readBinary();
        }
        int n3 = 0;
        while (n3 < n2) {
            this.cellTypes[n3] = n == 0 ? intReader.read() : intReader.readBinary();
            ++n3;
        }
        return true;
    }
}

