/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.VRMLAppearance;
import ncsa.j3d.loaders.vrml97.VRMLGeometry;
import ncsa.j3d.loaders.vrml97.VRMLShape;
import ncsa.j3d.loaders.vrml97.j3d.J3DAppearance;
import ncsa.j3d.loaders.vrml97.util.ToolkitShape;

public class J3DShape
implements ToolkitShape {
    Shape3D shape3D = null;
    GeometryArray g = null;
    Appearance app = null;
    VRMLAppearance appearance = null;
    VRMLGeometry geometry = null;
    String defName = null;

    public J3DShape() {
    }

    public J3DShape(VRMLShape vRMLShape) {
        this.produceShape(vRMLShape);
    }

    public BoundingBox getBoundingBox() {
        if (this.g == null) {
            return null;
        }
        int n = this.g.getVertexCount();
        if (n <= 0) {
            return null;
        }
        Point3d[] point3dArray = new Point3d[n];
        int n2 = 0;
        while (n2 < n) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        this.g.getCoordinates(0, point3dArray);
        BoundingBox boundingBox = new BoundingBox();
        int n3 = 0;
        while (n3 < n) {
            boundingBox.combine(point3dArray[n3]);
            ++n3;
        }
        return boundingBox;
    }

    public String getDefName() {
        return this.defName;
    }

    public Group getShape() {
        Group group = new Group();
        group.setCapability(12);
        group.addChild((Node)this.shape3D);
        return group;
    }

    public VRMLGeometry getVRMLGeometry() {
        return this.geometry;
    }

    public void produceShape(VRMLShape vRMLShape) {
        J3DAppearance j3DAppearance;
        this.appearance = vRMLShape.getAppearance();
        this.app = this.appearance != null ? ((j3DAppearance = new J3DAppearance(this.appearance)) == null ? new Appearance() : j3DAppearance.getAppearance()) : new Appearance();
        this.app.setCapability(10);
        this.app.setCapability(11);
        j3DAppearance = this.app.getTransparencyAttributes();
        if (j3DAppearance == null) {
            j3DAppearance = new TransparencyAttributes();
        }
        j3DAppearance.setCapability(2);
        j3DAppearance.setCapability(3);
        this.app.setTransparencyAttributes((TransparencyAttributes)j3DAppearance);
        this.geometry = vRMLShape.getGeometry();
        this.defName = vRMLShape.getDefName();
    }
}

