/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.Material;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.MFColor;
import ncsa.j3d.loaders.vrml97.MFInt32;
import ncsa.j3d.loaders.vrml97.MFVec3f;
import ncsa.j3d.loaders.vrml97.SFColor;
import ncsa.j3d.loaders.vrml97.SFVec3f;
import ncsa.j3d.loaders.vrml97.VRMLColor;
import ncsa.j3d.loaders.vrml97.VRMLCoordinate;
import ncsa.j3d.loaders.vrml97.VRMLIndexedLineSet;
import ncsa.j3d.loaders.vrml97.VRMLMaterial;
import ncsa.j3d.loaders.vrml97.VRMLShape;
import ncsa.j3d.loaders.vrml97.j3d.J3DShape;

public class J3DIndexedLineSet
extends J3DShape {
    private Point3d[] set = new Point3d[1000];
    private int setIndex = 0;
    private boolean noAppearance = false;
    String defName = null;
    BoundingBox bounds = null;

    public J3DIndexedLineSet(VRMLShape vRMLShape) {
        super(vRMLShape);
        VRMLMaterial vRMLMaterial = this.appearance.getMaterial();
        GeometryArray geometryArray = this.buildIndexedLineSet(vRMLMaterial);
        if (this.noAppearance) {
            this.app = new Appearance();
            this.app.setCapability(0);
            this.app.setCapability(10);
            this.app.setCapability(11);
            TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
            transparencyAttributes.setCapability(2);
            transparencyAttributes.setCapability(3);
            this.app.setTransparencyAttributes(transparencyAttributes);
            Material material = new Material();
            material.setCapability(0);
            Color3f color3f = this.getColor3f(vRMLMaterial.getEmissiveColor());
            material.setEmissiveColor(color3f);
            material.setShininess(26.4f);
            material.setLightingEnable(false);
            this.app.setMaterial(material);
            RenderingAttributes renderingAttributes = new RenderingAttributes();
            renderingAttributes.setDepthBufferEnable(true);
            this.app.setRenderingAttributes(renderingAttributes);
        } else {
            Material material = this.app.getMaterial();
            material.setLightingEnable(false);
            this.app.setMaterial(material);
        }
        this.shape3D = new Shape3D((Geometry)geometryArray, this.app);
        this.shape3D.setCapability(14);
        this.shape3D.setCapability(12);
        this.shape3D.setCapability(3);
        this.shape3D.setCapability(4);
        this.shape3D.setUserData((Object)this.bounds);
        this.defName = vRMLShape.getDefName();
    }

    private void addLine(Point3d point3d, Point3d point3d2) {
        if (this.set.length - this.setIndex < 2) {
            Point3d[] point3dArray = new Point3d[this.set.length * 2];
            System.arraycopy(this.set, 0, point3dArray, 0, this.set.length);
            this.set = point3dArray;
        }
        this.set[this.setIndex++] = point3d;
        this.set[this.setIndex++] = point3d2;
    }

    public GeometryArray buildIndexedLineSet(VRMLMaterial vRMLMaterial) {
        LineArray lineArray;
        block14: {
            int n;
            VRMLColor vRMLColor;
            boolean bl;
            boolean bl2;
            MFInt32 mFInt32;
            VRMLIndexedLineSet vRMLIndexedLineSet;
            block13: {
                vRMLIndexedLineSet = (VRMLIndexedLineSet)this.geometry;
                VRMLCoordinate vRMLCoordinate = vRMLIndexedLineSet.getCoordinate();
                mFInt32 = vRMLIndexedLineSet.getCoordIndex();
                MFVec3f mFVec3f = vRMLCoordinate.getPoint();
                int n2 = vRMLCoordinate.getSize();
                Point3d[] point3dArray = new Point3d[n2];
                bl2 = false;
                bl = vRMLIndexedLineSet.getColorPerVertex();
                int n3 = 0;
                while (n3 < n2) {
                    SFVec3f sFVec3f = mFVec3f.getElement(n3);
                    point3dArray[n3] = new Point3d((double)sFVec3f.getX(), (double)sFVec3f.getY(), (double)sFVec3f.getZ());
                    ++n3;
                }
                this.bounds = new BoundingBox(point3dArray[0], point3dArray[0]);
                this.bounds.combine(point3dArray);
                int n4 = mFInt32.getSize();
                int[] nArray = new int[n4];
                int n5 = 0;
                while (n5 < n4) {
                    nArray[n5] = mFInt32.getElement(n5);
                    ++n5;
                }
                int n6 = 0;
                while (n6 < nArray.length) {
                    int n7 = nArray[n6++];
                    int n8 = nArray[n6++];
                    int n9 = n7;
                    while (n8 != -1) {
                        this.addLine(point3dArray[n9], point3dArray[n8]);
                        n9 = n8;
                        n8 = nArray[n6++];
                    }
                }
                lineArray = new LineArray(this.setIndex, 5);
                lineArray.setCapability(2);
                lineArray.setCapability(17);
                lineArray.setCapability(8);
                lineArray.setCapability(0);
                Point3d[] point3dArray2 = new Point3d[this.setIndex];
                System.arraycopy(this.set, 0, point3dArray2, 0, this.setIndex);
                lineArray.setCoordinates(0, point3dArray2);
                vRMLColor = vRMLIndexedLineSet.getColor();
                if (vRMLColor != null) break block13;
                this.noAppearance = true;
                Color3f color3f = this.getColor3f(vRMLMaterial.getEmissiveColor());
                int n10 = 0;
                while (n10 < this.setIndex) {
                    lineArray.setColor(n10, color3f);
                    ++n10;
                }
                break block14;
            }
            MFInt32 mFInt322 = vRMLIndexedLineSet.getColorIndex();
            MFColor mFColor = vRMLColor.getColor();
            if (mFInt322 == null) {
                n = mFInt32.getSize();
                bl2 = true;
            } else {
                n = mFInt322.getSize();
            }
            int n11 = 0;
            int n12 = 0;
            while (n12 < n) {
                block17: {
                    int n13;
                    block16: {
                        block15: {
                            if (!bl2) break block15;
                            n13 = mFInt32.getElement(n12);
                            if (n13 != -1) break block16;
                            if (++n12 >= n) break block17;
                            n13 = mFInt32.getElement(n12);
                            break block16;
                        }
                        n13 = mFInt322.getElement(n12);
                        if (n13 != -1) break block16;
                        if (++n12 >= n) break block17;
                        n13 = mFInt322.getElement(n12);
                    }
                    SFColor sFColor = mFColor.getElement(n13);
                    lineArray.setColor(n11++, this.getColor3f(sFColor));
                    if (!bl) {
                        lineArray.setColor(n11++, this.getColor3f(sFColor));
                    }
                }
                ++n12;
            }
        }
        return lineArray;
    }

    private Color3f getColor3f(SFColor sFColor) {
        return new Color3f(sFColor.getRed(), sFColor.getGreen(), sFColor.getBlue());
    }
}

