/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.vrml97.MFColor;
import ncsa.j3d.loaders.vrml97.MFInt32;
import ncsa.j3d.loaders.vrml97.MFVec3f;
import ncsa.j3d.loaders.vrml97.SFColor;
import ncsa.j3d.loaders.vrml97.SFVec3f;
import ncsa.j3d.loaders.vrml97.VRMLColor;
import ncsa.j3d.loaders.vrml97.VRMLCoordinate;
import ncsa.j3d.loaders.vrml97.VRMLIndexedFaceSet;
import ncsa.j3d.loaders.vrml97.VRMLNormal;
import ncsa.j3d.loaders.vrml97.VRMLShape;
import ncsa.j3d.loaders.vrml97.j3d.J3DAppearance;
import ncsa.j3d.loaders.vrml97.j3d.J3DShape;
import ncsa.vecmath.IndexedPolygon;

public class J3DIndexedFaceSet
extends J3DShape {
    private Vector3f[] surfNormals = new Vector3f[100];
    private int surfNormalIndex = 0;
    private Vector3f[] pointNormals = new Vector3f[100];
    private int pointNormalIndex = 0;
    IndexedGeometryArray tri = null;
    IndexedPolygon indexedPolygon = null;
    MFInt32 coordIndex = null;
    int[] coords = null;
    int[][] pointIndices = null;
    BoundingBox bounds = null;

    public J3DIndexedFaceSet(VRMLShape vRMLShape) {
        Object object;
        this.appearance = vRMLShape.getAppearance();
        if (this.appearance != null) {
            object = new J3DAppearance(this.appearance);
            ((J3DAppearance)object).setLightingEnable(true);
            this.app = ((J3DAppearance)object).getAppearance();
        } else {
            this.app = new Appearance();
            this.app.setCapability(0);
        }
        this.geometry = vRMLShape.getGeometry();
        object = (VRMLIndexedFaceSet)this.geometry;
        if (!((VRMLIndexedFaceSet)object).getSolid()) {
            PolygonAttributes polygonAttributes = new PolygonAttributes();
            polygonAttributes.setCullFace(0);
            polygonAttributes.setBackFaceNormalFlip(true);
            this.app.setPolygonAttributes(polygonAttributes);
        }
        this.g = this.buildIndexedFaceSet();
        this.shape3D = new Shape3D((Geometry)this.g, this.app);
        this.shape3D.setCapability(14);
        this.shape3D.setCapability(12);
        this.shape3D.setCapability(3);
        this.shape3D.setCapability(4);
        this.shape3D.setUserData((Object)this.bounds);
    }

    private GeometryArray buildIndexedFaceSet() {
        VRMLIndexedFaceSet vRMLIndexedFaceSet = (VRMLIndexedFaceSet)this.geometry;
        VRMLCoordinate vRMLCoordinate = vRMLIndexedFaceSet.getCoordinate();
        this.coordIndex = vRMLIndexedFaceSet.getCoordIndex();
        MFVec3f mFVec3f = vRMLCoordinate.getPoint();
        int n = vRMLCoordinate.getSize();
        Point3d[] point3dArray = new Point3d[n];
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            SFVec3f sFVec3f = mFVec3f.getElement(n3);
            Point3f point3f = new Point3f(sFVec3f.getX(), sFVec3f.getY(), sFVec3f.getZ());
            point3dArray[n3] = new Point3d(point3f);
            ++n3;
        }
        this.bounds = new BoundingBox(point3dArray[0], point3dArray[0]);
        this.bounds.combine(point3dArray);
        int n4 = 0;
        int n5 = -1;
        if (this.coordIndex != null) {
            n4 = this.coordIndex.getSize();
            this.coords = new int[n4];
            int n6 = 0;
            while (n6 < n4) {
                this.coords[n6] = this.coordIndex.getElement(n6);
                ++n6;
            }
            n2 = this.countDelimiters(this.coords);
            this.pointIndices = new int[n2][];
            int[] nArray = null;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                int n9 = this.calcDelimitedSize(n8, this.coords);
                nArray = new int[n9];
                int n10 = 0;
                while (n10 < n9) {
                    nArray[n10] = this.coords[n8 + n10];
                    ++n10;
                }
                this.pointIndices[n7++] = nArray;
                n8 += n9 + 1;
            }
            this.indexedPolygon = new IndexedPolygon(point3dArray, this.pointIndices);
        }
        this.setNormals(vRMLIndexedFaceSet);
        this.setColors(vRMLIndexedFaceSet);
        this.tri = this.indexedPolygon.getIndexedTriangleArray();
        return this.tri;
    }

    private int calcDelimitedSize(int n, int[] nArray) {
        int n2 = 0;
        int n3 = n;
        while (n3 < nArray.length) {
            if (nArray[n3] == -1) {
                return n2;
            }
            ++n2;
            ++n3;
        }
        return n2;
    }

    public Color3f convertColor(SFColor sFColor) {
        return new Color3f(sFColor.getRed(), sFColor.getGreen(), sFColor.getBlue());
    }

    private int countDelimiters(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == -1) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void setColors(VRMLIndexedFaceSet vRMLIndexedFaceSet) {
        int n;
        MFInt32 mFInt32 = vRMLIndexedFaceSet.getColorIndex();
        int n2 = -1;
        boolean bl = vRMLIndexedFaceSet.getColorPerVertex();
        MFInt32 mFInt322 = vRMLIndexedFaceSet.getCoordIndex();
        int n3 = -1;
        boolean bl2 = false;
        VRMLColor vRMLColor = vRMLIndexedFaceSet.getColor();
        if (vRMLColor == null) {
            return;
        }
        MFColor mFColor = vRMLColor.getColor();
        int n4 = mFColor.getSize();
        if (mFInt32 != null && (n2 = mFInt32.getSize()) == 0) {
            mFInt32 = null;
            n2 = -1;
        }
        Color3f[] color3fArray = new Color3f[n4];
        int n5 = 0;
        while (n5 < n4) {
            color3fArray[n5] = this.convertColor(mFColor.getElement(n5));
            ++n5;
        }
        if (mFInt322 != null) {
            n3 = mFInt322.getSize();
        }
        int[] nArray = null;
        if (n2 == -1) {
            nArray = new int[n3];
            n = 0;
            while (n < n3) {
                nArray[n] = mFInt322.getElement(n);
                ++n;
            }
            bl2 = true;
        } else {
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = mFInt32.getElement(n);
                ++n;
            }
        }
        n = this.countDelimiters(this.coords);
        int[][] nArray2 = new int[n][];
        if (bl) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < this.pointIndices.length) {
                n8 = this.pointIndices[n9].length;
                int[] nArray3 = new int[n8];
                int n10 = 0;
                while (n10 < n8) {
                    int n11 = bl2 ? mFInt322.getElement(n7++) : mFInt32.getElement(n7++);
                    nArray3[n10] = n11;
                    ++n10;
                }
                ++n7;
                nArray2[n6++] = nArray3;
                ++n9;
            }
        } else {
            int n12 = 0;
            int n13 = 0;
            if (bl2) {
                int n14 = 0;
                while (n14 < n3) {
                    int n15 = mFInt322.getElement(n14);
                    n13 = this.pointIndices[n14].length;
                    int[] nArray4 = new int[n13];
                    int n16 = 0;
                    while (n16 < n13) {
                        nArray4[n16] = n15;
                        ++n16;
                    }
                    nArray2[n12++] = nArray4;
                    ++n14;
                }
            } else {
                int n17 = 0;
                while (n17 < n2) {
                    int n18 = mFInt32.getElement(n17);
                    n13 = this.pointIndices[n17].length;
                    int[] nArray5 = new int[n13];
                    int n19 = 0;
                    while (n19 < n13) {
                        nArray5[n19] = n18;
                        ++n19;
                    }
                    nArray2[n12++] = nArray5;
                    ++n17;
                }
            }
        }
        this.indexedPolygon.setColors(color3fArray, nArray2);
    }

    private void setNormals(VRMLIndexedFaceSet vRMLIndexedFaceSet) {
        VRMLNormal vRMLNormal = vRMLIndexedFaceSet.getNormal();
        if (vRMLNormal == null) {
            return;
        }
        MFVec3f mFVec3f = vRMLNormal.getNormals();
        if (mFVec3f == null) {
            return;
        }
        MFInt32 mFInt32 = vRMLIndexedFaceSet.getNormalIndex();
        if (mFInt32 != null && mFInt32.getSize() != 0) {
            System.out.println("normalIndex = " + mFInt32);
            System.out.println("normal Index specified.");
            System.out.println("that feature is unimplemented");
            System.exit(0);
            return;
        }
        if (this.coordIndex == null) {
            System.out.println("normals specified, but no normalIndex or coordIndex specified.");
            return;
        }
        Vector3f[] vector3fArray = new Vector3f[mFVec3f.getSize()];
        int n = 0;
        while (n < mFVec3f.getSize()) {
            SFVec3f sFVec3f = mFVec3f.getElement(n);
            vector3fArray[n] = new Vector3f(sFVec3f.x, sFVec3f.y, sFVec3f.z);
            ++n;
        }
        this.indexedPolygon.setNormals(vector3fArray, this.pointIndices);
    }
}

