/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97.j3d;

import java.util.Vector;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import ncsa.j3d.loaders.vrml97.ChildNode;
import ncsa.j3d.loaders.vrml97.GroupingNode;
import ncsa.j3d.loaders.vrml97.MFNode;
import ncsa.j3d.loaders.vrml97.VRMLAnchor;
import ncsa.j3d.loaders.vrml97.VRMLNode;
import ncsa.j3d.loaders.vrml97.VRMLShape;
import ncsa.j3d.loaders.vrml97.VRMLTransform;
import ncsa.j3d.loaders.vrml97.j3d.J3DAnchor;
import ncsa.j3d.loaders.vrml97.j3d.J3DShape;
import ncsa.j3d.loaders.vrml97.j3d.J3DTransform;
import ncsa.j3d.loaders.vrml97.util.ToolkitGroup;

public class J3DGroup
implements ToolkitGroup {
    Group group = null;
    boolean debug = false;
    Vector defList = null;
    static String GROUP_MAGIC_TAG = new String("J3D__Group__");

    public J3DGroup() {
    }

    public J3DGroup(GroupingNode groupingNode) {
        this.produceGroup(groupingNode);
    }

    private void addDefName(String string, Object object) {
        if (this.defList == null) {
            this.defList = new Vector();
        }
        this.defList.addElement(new DefPair(string, object));
    }

    public Group getGroup() {
        return this.group;
    }

    public Node getNamedObject(String string) {
        if (this.defList == null) {
            return null;
        }
        int n = 0;
        while (n < this.defList.size()) {
            DefPair defPair = (DefPair)this.defList.elementAt(n);
            if (defPair.name.equals(GROUP_MAGIC_TAG)) {
                J3DGroup j3DGroup = (J3DGroup)defPair.obj;
                Node node = j3DGroup.getNamedObject(string);
                if (node != null) {
                    return node;
                }
            } else if (defPair.name.equals(string)) {
                return (Node)defPair.obj;
            }
            ++n;
        }
        return null;
    }

    public void produceChild(ChildNode childNode) {
        Thread.dumpStack();
        System.exit(0);
    }

    public void produceGroup(GroupingNode groupingNode) {
        MFNode mFNode = groupingNode.getChildren();
        Group group = null;
        if (mFNode == null) {
            return;
        }
        this.group = new Group();
        this.group.setCapability(12);
        int n = mFNode.getSize();
        int n2 = 0;
        while (n2 < n) {
            J3DShape j3DShape;
            Object object;
            VRMLNode vRMLNode = mFNode.getElement(n2);
            if (vRMLNode instanceof VRMLShape) {
                object = (VRMLShape)vRMLNode;
                j3DShape = (J3DShape)((VRMLShape)object).produceShape();
                if (j3DShape != null && (group = j3DShape.getShape()) != null) {
                    this.group.addChild((Node)group);
                    String string = j3DShape.getDefName();
                    if (string != null) {
                        this.addDefName(string, group);
                    }
                }
            } else if (vRMLNode instanceof VRMLAnchor) {
                object = new J3DAnchor((VRMLAnchor)vRMLNode);
                j3DShape = ((J3DAnchor)object).getGroup();
                if (j3DShape != null) {
                    this.group.addChild((Node)j3DShape);
                }
            } else if (vRMLNode instanceof VRMLTransform) {
                object = new J3DTransform((VRMLTransform)vRMLNode);
                j3DShape = ((J3DTransform)object).getGroup();
                if (j3DShape != null) {
                    this.group.addChild((Node)j3DShape);
                } else if (this.debug) {
                    System.out.println("Group: newGroup == null!");
                }
            } else if (vRMLNode instanceof GroupingNode) {
                if (this.debug) {
                    System.out.println("Group: working on node = " + vRMLNode);
                }
                if ((j3DShape = ((J3DGroup)(object = new J3DGroup((GroupingNode)((Object)vRMLNode)))).getGroup()) != null) {
                    this.group.addChild((Node)j3DShape);
                    this.addDefName(GROUP_MAGIC_TAG, object);
                } else if (this.debug) {
                    System.out.println("Group: newGroup == null!");
                }
            } else if (this.debug) {
                System.out.println("Group: " + vRMLNode + " not implemented");
            }
            ++n2;
        }
    }

    class DefPair {
        String name;
        Object obj;

        public DefPair(String string, Object object) {
            this.name = string;
            this.obj = object;
        }
    }
}

