/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import ncsa.j3d.loaders.vrml97.SFColor;
import ncsa.j3d.loaders.vrml97.VRMLAppearance;
import ncsa.j3d.loaders.vrml97.VRMLMaterial;

public class J3DAppearance {
    Material material = null;
    GeometryArray g;
    VRMLAppearance app;
    Appearance appearance = null;

    public J3DAppearance(VRMLAppearance vRMLAppearance) {
        float f;
        this.app = vRMLAppearance;
        this.appearance = new Appearance();
        this.appearance.setCapability(0);
        this.appearance.setCapability(10);
        this.appearance.setCapability(11);
        VRMLMaterial vRMLMaterial = vRMLAppearance.getMaterial();
        this.material = this.getJ3DMaterial(vRMLMaterial);
        if (this.material != null) {
            this.appearance.setMaterial(this.material);
        }
        if (vRMLMaterial != null && (double)(f = vRMLMaterial.getTransparency().getValue()) > 0.0) {
            TransparencyAttributes transparencyAttributes = new TransparencyAttributes(1, f);
            transparencyAttributes.setCapability(2);
            transparencyAttributes.setCapability(3);
            this.appearance.setTransparencyAttributes(transparencyAttributes);
        }
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setDepthBufferEnable(true);
        this.appearance.setRenderingAttributes(renderingAttributes);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public Color3f getColor3f(SFColor sFColor) {
        return new Color3f(sFColor.getRed(), sFColor.getGreen(), sFColor.getBlue());
    }

    public Material getJ3DMaterial(VRMLMaterial vRMLMaterial) {
        if (vRMLMaterial == null) {
            return null;
        }
        Color3f color3f = this.getColor3f(vRMLMaterial.getEmissiveColor());
        Color3f color3f2 = this.getColor3f(vRMLMaterial.getDiffuseColor());
        Color3f color3f3 = this.getColor3f(vRMLMaterial.getSpecularColor());
        float f = vRMLMaterial.getShininess().getValue();
        f = f * 127.0f + 1.0f;
        float f2 = vRMLMaterial.getAmbientIntensity().getValue();
        Color3f color3f4 = new Color3f(color3f2);
        color3f4.scale(f2);
        Material material = new Material(color3f4, color3f, color3f2, color3f3, f);
        material.setCapability(0);
        material.setLightingEnable(true);
        return material;
    }

    public void setLightingEnable(boolean bl) {
        if (this.material != null) {
            this.material.setLightingEnable(bl);
            this.appearance.setMaterial(this.material);
        }
    }
}

