/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97.j3d;

import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.vrml97.GroupingNode;
import ncsa.j3d.loaders.vrml97.MFNode;
import ncsa.j3d.loaders.vrml97.VRMLAnchor;
import ncsa.j3d.loaders.vrml97.VRMLNode;
import ncsa.j3d.loaders.vrml97.VRMLShape;
import ncsa.j3d.loaders.vrml97.j3d.AnchorGroup;
import ncsa.j3d.loaders.vrml97.j3d.J3DGroup;
import ncsa.j3d.loaders.vrml97.j3d.J3DShape;
import ncsa.j3d.loaders.vrml97.util.ToolkitGroup;

public class J3DAnchor
implements ToolkitGroup {
    AnchorGroup group = null;
    String description = null;
    String[] parameter = null;
    String[] url = null;
    float bboxCenterX;
    float bboxCenterY;
    float bboxCenterZ;
    float bboxSizeX;
    float bboxSizeY;
    float bboxSizeZ;
    VRMLAnchor anchor = null;

    public J3DAnchor() {
    }

    public J3DAnchor(VRMLAnchor vRMLAnchor) {
        this.produceAnchor(vRMLAnchor);
    }

    public Group getGroup() {
        return this.group;
    }

    public void produceAnchor(VRMLAnchor vRMLAnchor) {
        this.anchor = vRMLAnchor;
        MFNode mFNode = vRMLAnchor.getChildren();
        this.group = new AnchorGroup();
        this.group.setCapability(1);
        this.group.setCapability(5);
        this.group.setCapability(3);
        this.group.setCapability(4);
        this.group.setDescription(vRMLAnchor.getDescription());
        this.group.setURL(vRMLAnchor.getURL());
        this.group.setParameter(vRMLAnchor.getParameter());
        int n = mFNode.getSize();
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 0.0);
        int n2 = 0;
        while (n2 < n) {
            J3DShape j3DShape;
            Object object;
            VRMLNode vRMLNode = mFNode.getElement(n2);
            if (vRMLNode instanceof VRMLShape) {
                Group group;
                object = (VRMLShape)vRMLNode;
                j3DShape = (J3DShape)((VRMLShape)object).produceShape();
                if (j3DShape != null && (group = j3DShape.getShape()) != null) {
                    Bounds bounds = group.getBounds();
                    boundingSphere.combine(bounds);
                    this.group.addChild((Node)group);
                }
            } else if (vRMLNode instanceof GroupingNode) {
                object = new J3DGroup((GroupingNode)((Object)vRMLNode));
                j3DShape = ((J3DGroup)object).getGroup();
                if (j3DShape != null) {
                    this.group.addChild((Node)j3DShape);
                } else {
                    System.out.println("Anchor: newGroup = " + j3DShape);
                }
            }
            ++n2;
        }
        this.group.setBounds((Bounds)boundingSphere);
    }
}

