/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97;

import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import ncsa.j3d.loaders.vrml97.VRMLNode;
import ncsa.j3d.loaders.vrml97.VRMLPROTO;
import ncsa.j3d.loaders.vrml97.VRMLViewpoint;
import ncsa.j3d.loaders.vrml97.util.ToolkitImpl;
import ncsa.util.ReaderTokenizer;

public class VRMLNodeManager {
    Vector nodeVector = new Vector(10, 10);
    Hashtable defTable = new Hashtable();
    Hashtable protoTable = new Hashtable();
    boolean debug = false;
    static String myPackage = "ncsa.j3d.loaders.vrml97.";
    ToolkitImpl impl = null;

    public VRMLNodeManager(ToolkitImpl toolkitImpl) {
        this.impl = toolkitImpl;
    }

    public void Debug(String string) {
        if (this.debug) {
            System.out.println("VRMLNodeManager: " + string);
        }
    }

    private void addNode(VRMLNode vRMLNode) {
        this.nodeVector.addElement(vRMLNode);
    }

    public boolean advance(ReaderTokenizer readerTokenizer) {
        try {
            readerTokenizer.nextToken();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    public void consume(ReaderTokenizer readerTokenizer, String string) {
        Object var3_3 = null;
        String string2 = null;
        String string3 = null;
        string2 = string;
        if (string.equals("USE")) {
            String string4 = this.getWord(readerTokenizer);
            if (string4 == null) {
                return;
            }
            VRMLNode vRMLNode = this.getDEF(string4);
            if (vRMLNode == null) {
                return;
            }
            VRMLNode vRMLNode2 = (VRMLNode)vRMLNode.clone();
            vRMLNode2.setUSE(string4);
            this.addNode(vRMLNode2);
            return;
        }
        if (string.equals("DEF")) {
            string3 = this.getWord(readerTokenizer);
            if (string3 == null) {
                return;
            }
            string2 = this.getWord(readerTokenizer);
            if (string2 == null) {
                return;
            }
        }
        try {
            var3_3 = Class.forName(String.valueOf(myPackage) + "VRML" + string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            VRMLPROTO vRMLPROTO = (VRMLPROTO)this.protoTable.get(string2);
            if (vRMLPROTO == null) {
                System.out.println("Can't find " + myPackage + "VRML" + string2);
                System.exit(10);
            }
            VRMLPROTO vRMLPROTO2 = (VRMLPROTO)vRMLPROTO.clone();
            VRMLNode vRMLNode = vRMLPROTO2.consume(readerTokenizer);
            vRMLNode.setDefName(string3);
            this.addNode(vRMLNode);
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            Thread.dumpStack();
            System.exit(10);
        }
        if (var3_3 instanceof VRMLPROTO) {
            VRMLPROTO vRMLPROTO = null;
            try {
                vRMLPROTO = var3_3;
                vRMLPROTO.setVRMLNodeManager(this);
                vRMLPROTO.initialize(readerTokenizer);
                System.out.print("PROTO ");
                System.out.println();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            this.protoTable.put(vRMLPROTO.getName(), vRMLPROTO);
            return;
        }
        VRMLNode vRMLNode = var3_3;
        try {
            vRMLNode.setVRMLNodeManager(this);
            vRMLNode.consume(readerTokenizer);
            if (string3 != null) {
                vRMLNode.setDefName(string3);
                this.defTable.put(string3, vRMLNode);
                this.addNode(vRMLNode);
                return;
            }
            this.addNode(vRMLNode);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(10);
        }
    }

    public VRMLNode createNode(ReaderTokenizer readerTokenizer, String string) {
        VRMLNode vRMLNode = null;
        String string2 = null;
        String string3 = null;
        string2 = string;
        if (string.equals("USE")) {
            String string4 = this.getWord(readerTokenizer);
            if (string4 == null) {
                return null;
            }
            vRMLNode = this.getDEF(string4);
            if (vRMLNode == null) {
                return null;
            }
            VRMLNode vRMLNode2 = (VRMLNode)vRMLNode.clone();
            vRMLNode2.setUSE(string4);
            return vRMLNode2;
        }
        if (string.equals("DEF")) {
            string3 = this.getWord(readerTokenizer);
            if (string3 == null) {
                return null;
            }
            string2 = this.getWord(readerTokenizer);
            if (string2 == null) {
                return null;
            }
        }
        if (string.equals("NULL")) {
            return null;
        }
        try {
            vRMLNode = (VRMLNode)Class.forName(String.valueOf(myPackage) + "VRML" + string2).newInstance();
            vRMLNode.setVRMLNodeManager(this);
            VRMLNode vRMLNode3 = vRMLNode.consume(readerTokenizer);
            if (string3 != null) {
                vRMLNode3.setDefName(string3);
                this.defTable.put(string3, vRMLNode3);
                return vRMLNode3;
            }
            return vRMLNode3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            VRMLPROTO vRMLPROTO = (VRMLPROTO)this.protoTable.get(string);
            if (vRMLPROTO == null) {
                System.out.println("Unknown keyword \"" + string + "\" on line " + readerTokenizer.lineno());
                return null;
            }
            VRMLPROTO vRMLPROTO2 = (VRMLPROTO)vRMLPROTO.clone();
            VRMLNode vRMLNode4 = vRMLPROTO2.consume(readerTokenizer);
            return vRMLNode4;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void dump(PrintWriter printWriter) {
        int n = 0;
        while (n < this.nodeVector.size()) {
            VRMLNode vRMLNode = (VRMLNode)this.nodeVector.elementAt(n);
            vRMLNode.dump(printWriter, "");
            ++n;
        }
    }

    public VRMLNode getDEF(String string) {
        VRMLNode vRMLNode = (VRMLNode)this.defTable.get(string);
        if (vRMLNode == null) {
            return null;
        }
        return vRMLNode;
    }

    public Field getField(VRMLNode vRMLNode, String string) {
        Field field2 = null;
        Class<?> clazz = vRMLNode.getClass();
        try {
            field2 = clazz.getDeclaredField("_" + string);
        }
        catch (Exception exception) {
            return null;
        }
        return field2;
    }

    public Vector getNodes() {
        return this.nodeVector;
    }

    public String getPackageName() {
        return myPackage;
    }

    public ToolkitImpl getToolkitImpl() {
        return this.impl;
    }

    public VRMLViewpoint getViewpoint() {
        if (this.debug) {
            System.out.println("nodeVector.size() = " + this.nodeVector.size());
        }
        int n = 0;
        while (n < this.nodeVector.size()) {
            VRMLNode vRMLNode = (VRMLNode)this.nodeVector.elementAt(n);
            if (this.debug) {
                System.out.println("n = " + vRMLNode);
            }
            if (vRMLNode instanceof VRMLViewpoint) {
                return (VRMLViewpoint)vRMLNode;
            }
            ++n;
        }
        return null;
    }

    public String getWord(ReaderTokenizer readerTokenizer) {
        if (!this.advance(readerTokenizer)) {
            return null;
        }
        if (readerTokenizer.ttype != -101) {
            System.out.println("syntax error on line " + readerTokenizer.lineno());
            return null;
        }
        return new String(readerTokenizer.sval);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }
}

