/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.vrml97;

import java.io.PrintWriter;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import ncsa.j3d.loaders.vrml97.VRMLType;
import ncsa.util.ReaderTokenizer;

public class SFRotation
extends VRMLType {
    float x;
    float y;
    float z;
    float radians;

    public SFRotation() {
    }

    public SFRotation(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.radians = n4;
    }

    public void dump(PrintWriter printWriter, String string) {
        printWriter.println(String.valueOf(string) + this.x + " " + this.y + " " + this.z + " " + this.radians);
    }

    public boolean equals(Object object) {
        SFRotation sFRotation = (SFRotation)object;
        float[] fArray = new float[4];
        sFRotation.getValue(fArray);
        return fArray[0] == this.x && fArray[1] == this.y && fArray[2] == this.z && fArray[3] == this.radians;
    }

    public AxisAngle4f getAxisAngle4f() {
        return new AxisAngle4f(this.x, this.y, this.z, this.radians);
    }

    public void getValue(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
        fArray[3] = this.radians;
    }

    public boolean populate(ReaderTokenizer readerTokenizer) {
        Vector<Float> vector = new Vector<Float>(4);
        int n = 0;
        while (n < 4) {
            try {
                readerTokenizer.nextToken();
            }
            catch (Exception exception) {
                System.out.println("error at " + readerTokenizer.lineno());
                return false;
            }
            if (readerTokenizer.ttype != -102) {
                System.out.print("Error at " + readerTokenizer.lineno() + " st.sval=" + readerTokenizer.sval + ", st.ttype = " + readerTokenizer.ttype + ": ");
                System.out.println(" expected floating point number");
                return false;
            }
            vector.addElement(new Float(readerTokenizer.nval));
            ++n;
        }
        this.x = ((Float)vector.elementAt(0)).floatValue();
        this.y = ((Float)vector.elementAt(1)).floatValue();
        this.z = ((Float)vector.elementAt(2)).floatValue();
        this.radians = ((Float)vector.elementAt(3)).floatValue();
        return true;
    }
}

