/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play.directives;

import java.util.Hashtable;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.InputDevice;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import ncsa.devices.NCSAInputDevice;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.tools.ToolManager;
import ncsa.util.ReaderTokenizer;

public class SensorDirective
extends Directive
implements InputDevice {
    String name;
    double[] matrix = new double[16];
    int[] buttons;

    public SensorDirective() {
    }

    public SensorDirective(Sensor sensor) {
        this.buttons = new int[sensor.getSensorButtonCount()];
        InputDevice inputDevice = sensor.getDevice();
        this.name = inputDevice instanceof NCSAInputDevice ? ((NCSAInputDevice)inputDevice).getName() : sensor.toString();
        Transform3D transform3D = new Transform3D();
        sensor.getRead(transform3D);
        transform3D.get(this.matrix);
        sensor.lastButtons(this.buttons);
    }

    public void close() {
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SensorDirective)) {
            return super.equals(object);
        }
        SensorDirective sensorDirective = (SensorDirective)object;
        int n = 0;
        while (n < this.matrix.length) {
            if (this.matrix[n] != sensorDirective.matrix[n]) {
                return false;
            }
            ++n;
        }
        if (this.buttons.length != sensorDirective.buttons.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.buttons.length) {
            if (this.buttons[n2] != sensorDirective.buttons[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void execute() {
        Transform3D transform3D = new Transform3D(this.matrix);
        SensorRead sensorRead = this.getSensorRead();
        sensorRead.setTime(System.currentTimeMillis());
        if (this.buttons.length > 0) {
            sensorRead.setButtons(this.buttons);
        }
        sensorRead.set(transform3D);
        this.getSensor().setNextSensorRead(sensorRead);
    }

    public String getName() {
        return this.name;
    }

    public int getProcessingMode() {
        return 4;
    }

    public Sensor getSensor() {
        return this.getSensor(0);
    }

    public Sensor getSensor(int n) {
        Hashtable hashtable = this.reader.getData().getSensorsHashtable();
        if (hashtable.containsKey(this.name)) {
            return (Sensor)hashtable.get(this.name);
        }
        Sensor sensor = null;
        Canvas3D canvas3D = ToolManager.instance().getCanvas();
        PhysicalEnvironment physicalEnvironment = canvas3D.getView().getPhysicalEnvironment();
        PortfolioProperties portfolioProperties = PortfolioProperties.instance();
        String string = portfolioProperties.getProperty(String.valueOf(this.name) + ".Channel");
        if (string != null) {
            sensor = physicalEnvironment.getSensor(Integer.parseInt(string));
        } else {
            System.out.println("ERROR: " + this.name + ".Channel not defined in portfolio.properties. The sensor cannot appear to the application.");
        }
        hashtable.put(this.name, sensor);
        return sensor;
    }

    public int getSensorCount() {
        return 1;
    }

    protected SensorRead getSensorRead() {
        Hashtable hashtable = this.reader.getData().getSensorReadsHashtable();
        if (hashtable.containsKey(this.name)) {
            return (SensorRead)hashtable.get(this.name);
        }
        SensorRead sensorRead = new SensorRead(this.buttons.length);
        hashtable.put(this.name, sensorRead);
        return sensorRead;
    }

    public boolean initialize() {
        return true;
    }

    public void initialize(ReaderTokenizer readerTokenizer) {
        int n = readerTokenizer.nextToken();
        this.time = (long)readerTokenizer.nval;
        n = readerTokenizer.nextToken();
        this.name = readerTokenizer.sval;
        int n2 = 0;
        while (n2 < this.matrix.length) {
            n = readerTokenizer.nextToken();
            this.matrix[n2] = readerTokenizer.nval;
            ++n2;
        }
        n = readerTokenizer.nextToken();
        this.buttons = new int[(int)readerTokenizer.nval];
        int n3 = 0;
        while (n3 < this.buttons.length) {
            n = readerTokenizer.nextToken();
            this.buttons[n3] = (int)readerTokenizer.nval;
            ++n3;
        }
    }

    public boolean intermediate(long l) {
        return false;
    }

    public void pollAndProcessInput() {
    }

    public void processStreamInput() {
    }

    void set(Transform3D transform3D) {
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int n) {
    }

    public String toString() {
        String string = "ncsa.j3d.loaders.play.directives.SensorDirective " + this.time + " " + this.name + " " + this.matrix[0] + " " + this.matrix[1] + " " + this.matrix[2] + " " + this.matrix[3] + " " + this.matrix[4] + " " + this.matrix[5] + " " + this.matrix[6] + " " + this.matrix[7] + " " + this.matrix[8] + " " + this.matrix[9] + " " + this.matrix[10] + " " + this.matrix[11] + " " + this.matrix[12] + " " + this.matrix[13] + " " + this.matrix[14] + " " + this.matrix[15] + " " + this.buttons.length;
        int n = 0;
        while (n < this.buttons.length) {
            string = String.valueOf(string) + " " + this.buttons[n];
            ++n;
        }
        return string;
    }
}

