/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play.directives;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.util.ReaderTokenizer;

public class Rotate
extends Directive {
    double angle;
    String axis;
    String name;
    double intermediate;
    Transform3D _t = new Transform3D();
    Transform3D _r = new Transform3D();

    public void execute() {
        this.rotate(this.angle - this.intermediate);
        this.intermediate = 0.0;
    }

    public void initialize(ReaderTokenizer readerTokenizer) {
        int n = readerTokenizer.nextToken();
        this.time = (long)readerTokenizer.nval;
        n = readerTokenizer.nextToken();
        this.name = readerTokenizer.sval;
        n = readerTokenizer.nextToken();
        this.axis = readerTokenizer.sval;
        n = readerTokenizer.nextToken();
        this.angle = readerTokenizer.nval;
        this.intermediate = 0.0;
    }

    public boolean intermediate(long l) {
        if (this.time == 0L) {
            return false;
        }
        double d = (double)l / (double)this.time * this.angle;
        this.rotate(d - this.intermediate);
        this.intermediate = d;
        return true;
    }

    protected void rotate(double d) {
        double d2 = d * (Math.PI / 180);
        TransformGroup transformGroup = this.reader.getData().getTransform(this.name);
        if (transformGroup != null) {
            transformGroup.getTransform(this._t);
            this._r.setIdentity();
            if (this.axis.equalsIgnoreCase("x")) {
                this._r.rotX(d2);
            } else if (this.axis.equalsIgnoreCase("y")) {
                this._r.rotY(d2);
            } else if (this.axis.equalsIgnoreCase("z")) {
                this._r.rotZ(d2);
            }
            this._t.mul(this._r);
            transformGroup.setTransform(this._t);
        }
    }

    public String toString() {
        return "ncsa.j3d.loaders.play.directives.Rotate " + this.time + " " + this.name + " " + this.axis + " " + this.angle;
    }
}

