/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play.directives;

import com.sun.j3d.loaders.Scene;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.loaders.ModelLoader;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.util.ReaderTokenizer;

public class LoadFile
extends Directive {
    String fileName = null;
    String groupName = null;
    BranchGroup bg;

    public void execute() {
        if (!this.bg.isLive()) {
            this.reader.getData().addBranchGroup(this.bg);
        }
    }

    public void initialize(ReaderTokenizer readerTokenizer) {
        int n = readerTokenizer.nextToken();
        this.fileName = readerTokenizer.sval;
        n = readerTokenizer.nextToken();
        this.groupName = readerTokenizer.sval;
        if (this.reader != null) {
            this.setup();
        }
    }

    public void reset() {
        TransformGroup transformGroup = this.reader.getData().getTransform(this.groupName);
        if (transformGroup != null) {
            transformGroup.setTransform(new Transform3D());
        }
        if (this.reader.getState().getObliteration()) {
            this.undo();
        }
    }

    protected void setup() {
        try {
            PickableTransformGroup pickableTransformGroup = new PickableTransformGroup();
            ModelLoader modelLoader = new ModelLoader();
            Scene scene = modelLoader.load(this.fileName);
            pickableTransformGroup.addChild((Node)scene.getSceneGroup());
            this.bg = new BranchGroup();
            this.bg.setCapability(17);
            this.reader.getData().addTransform(this.groupName, pickableTransformGroup);
            this.bg.addChild((Node)pickableTransformGroup);
        }
        catch (Exception exception) {
            System.out.println(this.toString());
            System.out.println(exception);
        }
    }

    public String toString() {
        return "ncsa.j3d.loaders.play.directives.LoadFile " + this.fileName + " " + this.groupName;
    }

    public void undo() {
        try {
            this.bg.detach();
        }
        catch (Exception exception) {
            System.out.println(this.toString());
            System.out.println(exception);
        }
    }
}

