/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.loaders.play.directives.LoadFile;
import ncsa.j3d.loaders.play.directives.Transform;
import ncsa.j3d.ui.record.RecordableTransform;

public class PlayWriter {
    protected static PrintWriter out = null;
    protected static long startTime = 0L;
    protected static String filename;
    public static boolean debug;
    protected static long last;

    static {
        debug = false;
        last = 0L;
    }

    public static void close() {
        if (filename == null) {
            return;
        }
        out.flush();
        out.close();
        out = null;
        if (debug) {
            System.out.println("Closing record file");
        }
    }

    protected static long generateTimeStamp() {
        long l = System.currentTimeMillis();
        long l2 = last == 0L ? last : l - last;
        last = l;
        return l2;
    }

    public static void loadFile(String string) {
        filename = string;
    }

    public static void nameFile(PickableTransformGroup pickableTransformGroup) {
        PlayWriter.writeFile(filename, pickableTransformGroup.getName());
    }

    public static void nameFile(RecordableTransform recordableTransform) {
        PlayWriter.writeFile(filename, recordableTransform.getDescription());
    }

    public static void open(String string) {
        if (out != null) {
            return;
        }
        try {
            out = new PrintWriter(new FileOutputStream(String.valueOf(string) + ".play"), true);
            startTime = System.currentTimeMillis();
            if (debug) {
                System.out.println("Opened " + string + ".play");
            }
        }
        catch (IOException iOException) {
            System.out.println("Recorder " + iOException);
        }
    }

    public static void write(String string, double d) {
        System.out.println("should not be writing  DOUBLE " + string + " " + d);
    }

    public static void write(String string, int n) {
        System.out.println("should not be writing  INTEGER " + string + " " + n);
    }

    public static void write(String string, TransformGroup transformGroup) {
        if (out == null) {
            return;
        }
        Transform transform = new Transform();
        double[] dArray = new double[16];
        Transform3D transform3D = new Transform3D();
        transformGroup.getTransform(transform3D);
        transform3D.get(dArray);
        String string2 = String.valueOf(PlayWriter.generateTimeStamp()) + " " + string + " " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5] + " " + dArray[6] + " " + dArray[7] + " " + dArray[8] + " " + dArray[9] + " " + dArray[10] + " " + dArray[11] + " " + dArray[12] + " " + dArray[13] + " " + dArray[14] + " " + dArray[15];
        transform.initialize(string2);
        PlayWriter.write(transform);
        if (debug) {
            System.out.println("wrote " + string);
        }
    }

    public static void write(String string, boolean bl) {
        System.out.println("should not be writing BOOLEAN " + string + " " + bl);
    }

    public static void write(String string, double[] dArray) {
        System.out.println("Should not be writing double[]  " + string);
    }

    public static void write(PickableTransformGroup pickableTransformGroup) {
        PlayWriter.write(pickableTransformGroup.getName(), pickableTransformGroup);
    }

    public static void write(Directive directive) {
        if (out == null) {
            return;
        }
        directive.setTime(PlayWriter.generateTimeStamp());
        out.println(directive.toString());
        out.flush();
    }

    public static void write(RecordableTransform recordableTransform) {
        if (out == null) {
            return;
        }
        PlayWriter.write(recordableTransform.getDescription(), recordableTransform);
    }

    public static void writeFile(String string, String string2) {
        if (out == null) {
            return;
        }
        LoadFile loadFile = new LoadFile();
        loadFile.initialize(String.valueOf(string) + " " + string2);
        PlayWriter.write(loadFile);
    }
}

