/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.Reader;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnActivation;
import javax.vecmath.Point3d;
import ncsa.j3d.loaders.play.DirectiveInterface;
import ncsa.j3d.loaders.play.PlayConfiguration;
import ncsa.j3d.loaders.play.PlayData;
import ncsa.j3d.loaders.play.PlayParser;
import ncsa.j3d.loaders.play.TimeBase;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.ui.record.NeedsCanvasForRecord;
import ncsa.j3d.ui.record.RendezvousInterface;

public class PlayReader
extends Behavior
implements DirectiveInterface,
Runnable,
NeedsCanvasForRecord {
    PlayConfiguration state = new PlayConfiguration();
    PlayData data;
    Thread thread = null;
    TimeBase time = null;

    public PlayReader(Reader reader) {
        this(reader, new PlayData());
    }

    public PlayReader(Reader reader, PlayData playData) {
        this.data = playData;
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(), 100000.0));
        if (reader != null) {
            PlayParser playParser = new PlayParser(reader);
            playParser.setInterface(this);
            playParser.process();
        }
    }

    public PlayReader(PlayData playData) {
        this(null, playData);
    }

    public Scene consume() {
        SceneBase sceneBase = new SceneBase();
        sceneBase.setSceneGroup(this.data.getRoot());
        sceneBase.addDescription("PLAY File");
        sceneBase.addBehaviorNode((Behavior)this);
        return sceneBase;
    }

    public PlayData getData() {
        return this.data;
    }

    public PlayConfiguration getState() {
        return this.state;
    }

    public void initialize() {
        this.time = new TimeBase(this.state);
        this.wakeupOn((WakeupCondition)new WakeupOnActivation());
    }

    public void initializeDirective(Directive directive) {
        directive.setReader(this);
    }

    protected void process(Directive directive) {
        this.time.startNewEvent();
        try {
            while (directive.getTime() > this.time.elapsed() && directive.intermediate(this.time.elapsed())) {
                this.state.rendezvous();
                Thread.yield();
                this.time.increment();
            }
        }
        catch (Exception exception) {
            System.out.println("PlayReader.process - intermediate");
            System.out.println(directive.toString());
            System.out.println(exception);
        }
        if (this.state.getStall()) {
            this.time.stall(directive.getTime());
        }
        this.state.rendezvous();
        directive.execute();
        this.time.increment();
        this.data.setNextIndex();
    }

    public void processDirective(Directive directive) {
        this.getData().addDirective(directive);
    }

    public void processStimulus(Enumeration enumeration) {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void rendezvous() {
        this.state.rendezvous();
    }

    protected void reset() {
        Enumeration enumeration = this.getData().getDirectives();
        while (enumeration.hasMoreElements()) {
            ((Directive)enumeration.nextElement()).reset();
        }
    }

    public void run() {
        while (this.state.getLoop()) {
            this.data.setIndex(0);
            while (this.data.getIndex() < this.data.directivesSize()) {
                this.process(this.data.getCurrentDirective());
            }
            if (!this.state.getLoop()) continue;
            this.time.startNewEvent();
            this.reset();
            this.time.stall(this.state.getLagTime());
        }
        System.out.println("PLAY done");
    }

    public void setRendezvous(RendezvousInterface rendezvousInterface) {
        this.state.setRendezvous(rendezvousInterface);
    }
}

