/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ncsa.j3d.loaders.play.PlayData;
import ncsa.j3d.loaders.play.directives.Directive;
import ncsa.j3d.loaders.play.directives.Editor;
import ncsa.util.ReaderTokenizer;

public class PlayEditor
implements ActionListener {
    Frame frame = null;
    PlayData data;
    JList list = new JList();
    Editor edir = null;

    public PlayEditor(Editor editor) {
        this.edir = editor;
        this.frame = new Frame("Play Editor");
        this.frame.setLayout(new BorderLayout());
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.frame.addWindowListener(windowAdapter);
        this.frame.setMenuBar(this.createMenuBar());
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.frame.add(jScrollPane);
        ((Component)this.frame).setSize(300, 300);
        ((Component)this.frame).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Edit")) {
            this.edit(this.list.getSelectedIndex());
        }
        if (string.equals("Remove")) {
            this.data.removeDirective(this.list.getSelectedIndex());
        }
        if (string.equals("Insert")) {
            this.insert(this.list.getSelectedIndex());
        }
        if (string.equals("Append")) {
            this.insert(this.list.getSelectedIndex() + 1);
        }
        if (string.equals("Save")) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.showSaveDialog(this.frame);
            File file = jFileChooser.getSelectedFile();
            try {
                this.data.write(new FileOutputStream(file));
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        this.refresh();
    }

    protected Directive composeDirective(String string) {
        try {
            StringReader stringReader = new StringReader(string);
            ReaderTokenizer readerTokenizer = new ReaderTokenizer(stringReader);
            readerTokenizer.wordChars(47, 47);
            int n = readerTokenizer.nextToken();
            Directive directive = (Directive)Class.forName(readerTokenizer.sval).newInstance();
            directive.setReader(this.edir.getReader());
            directive.initialize(readerTokenizer);
            return directive;
        }
        catch (Exception exception) {
            System.out.println("PlayEditor.composeDirective");
            System.out.println(exception);
            return null;
        }
    }

    protected MenuBar createMenuBar() {
        Menu menu = new Menu("Command");
        menu.add(this.register(new MenuItem("Edit")));
        menu.add(this.register(new MenuItem("Insert")));
        menu.add(this.register(new MenuItem("Append")));
        menu.add(this.register(new MenuItem("Remove")));
        Menu menu2 = new Menu("File");
        menu2.add(this.register(new MenuItem("Save")));
        MenuBar menuBar = new MenuBar();
        menuBar.add(menu2);
        menuBar.add(menu);
        return menuBar;
    }

    protected void edit(int n) {
        if (n == -1) {
            return;
        }
        Directive directive = this.data.getDirective(n);
        String string = this.writeDirective(directive);
        string = this.editor(string);
        directive = this.composeDirective(string);
        this.data.removeDirective(n);
        this.data.insertDirective(n, directive);
    }

    protected String editor(String string) {
        JDialog jDialog = new JDialog(this.frame, "Command Editor", true);
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setSize(jTextArea.getPreferredSize());
        jDialog.getContentPane().add(jTextArea);
        jDialog.show();
        return jTextArea.getText();
    }

    protected void insert(int n) {
        if (n == -1) {
            return;
        }
        Directive directive = this.composeDirective(this.editor(null));
        this.data.insertDirective(n, directive);
    }

    public static void main(String[] stringArray) {
        Editor editor = new Editor();
        PlayEditor playEditor = new PlayEditor(editor);
        playEditor.setData(new PlayData());
    }

    public void refresh() {
        this.list.setListData(this.data.directives);
    }

    protected MenuItem register(MenuItem menuItem) {
        menuItem.addActionListener(this);
        return menuItem;
    }

    public void setData(PlayData playData) {
        this.data = playData;
        this.refresh();
    }

    protected String writeDirective(Directive directive) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            directive.write(printWriter);
            printWriter.flush();
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            System.out.println("PlayEditor.writeDirective");
            System.out.println(exception);
            return null;
        }
    }
}

