/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.play;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.loaders.play.directives.Directive;

public class PlayData {
    Vector directives = new Vector();
    Vector views = new Vector();
    Vector initialViews = new Vector();
    Hashtable groups = new Hashtable();
    int index = 0;
    BranchGroup group;
    BranchGroup root;
    Hashtable sensors = new Hashtable();
    Hashtable reads = new Hashtable();

    PlayData() {
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.root.setCapability(13);
        this.root.setCapability(12);
        this.group = new BranchGroup();
        this.group.setCapability(14);
        this.group.setCapability(13);
        this.group.setCapability(12);
        this.group.setCapability(17);
        this.root.addChild((Node)this.group);
    }

    public void addBranchGroup(BranchGroup branchGroup) {
        this.group.addChild((Node)branchGroup);
    }

    void addDirective(Directive directive) {
        this.directives.addElement(directive);
    }

    public void addTransform(String string, TransformGroup transformGroup) {
        this.groups.put(string, transformGroup);
    }

    void addView(String string, TransformGroup transformGroup) {
        this.addTransform(string, transformGroup);
        this.views.addElement(string);
    }

    void decrementIndex() {
        --this.index;
    }

    int directivesSize() {
        return this.directives.size();
    }

    Directive getCurrentDirective() {
        return this.getDirective(this.index);
    }

    Directive getDirective(int n) {
        return (Directive)this.directives.elementAt(n);
    }

    Enumeration getDirectives() {
        return this.directives.elements();
    }

    BranchGroup getGroup() {
        return this.group;
    }

    int getIndex() {
        return this.index;
    }

    BranchGroup getRoot() {
        return this.root;
    }

    public Hashtable getSensorReadsHashtable() {
        return this.reads;
    }

    public Hashtable getSensorsHashtable() {
        return this.sensors;
    }

    public TransformGroup getTransform(String string) {
        return (TransformGroup)this.groups.get(string);
    }

    void incrementIndex() {
        ++this.index;
    }

    void insertDirective(int n, Directive directive) {
        this.directives.add(n, directive);
    }

    Object removeDirective(int n) {
        return this.directives.remove(n);
    }

    void setIndex(int n) {
        this.index = n;
    }

    void setNextIndex() {
        this.incrementIndex();
    }

    public void write(OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        Enumeration enumeration = this.getDirectives();
        while (enumeration.hasMoreElements()) {
            ((Directive)enumeration.nextElement()).write(printWriter);
        }
        printWriter.flush();
        printWriter.close();
    }

    public void write(String string) {
        try {
            this.write(new FileOutputStream(string));
        }
        catch (IOException iOException) {
            System.out.println("PlayData.write " + iOException);
        }
    }
}

