/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.pdb.records;

import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.pdb.AtomManager;
import ncsa.j3d.loaders.pdb.Record;

public class HETATM
extends Record {
    protected static long count = 0L;
    String serial = null;
    String name = null;
    String altLoc = null;
    String resName = null;
    String chainID = null;
    String resSeq = null;
    String iCode = null;
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;
    String occupancy = null;
    String tempFactor = null;
    String segID = null;
    String element = null;
    String charge = null;
    Node node = null;

    public HETATM() {
        ++count;
    }

    protected void buildNode() {
        TransformGroup transformGroup = new TransformGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.set(new Vector3f(this.getX(), this.getY(), this.getZ()));
        transformGroup.setTransform(transform3D);
        Node node = AtomManager.getNodeByName(this.getName());
        transformGroup.addChild(node);
        node.setCapability(9);
        node.setBoundsAutoCompute(true);
        transformGroup.setCapability(9);
        transformGroup.setBoundsAutoCompute(true);
        this.node = transformGroup;
    }

    public String getAltLoc() {
        return this.altLoc;
    }

    public String getChainID() {
        return this.chainID;
    }

    public String getCharge() {
        return this.charge;
    }

    public static long getCount() {
        return count;
    }

    public String getElement() {
        return this.element;
    }

    public String getICode() {
        return this.iCode;
    }

    public String getName() {
        return this.name;
    }

    public Node getNode() {
        return this.node;
    }

    public String getOccupancy() {
        return this.occupancy;
    }

    public String getResName() {
        return this.resName;
    }

    public String getResSeq() {
        return this.resSeq;
    }

    public String getSegID() {
        return this.segID;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getTempFactor() {
        return this.tempFactor;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void read(String string) {
        this.serial = string.substring(7, 11).trim();
        this.name = string.substring(12, 16).trim();
        this.altLoc = string.substring(16, 17).trim();
        this.resName = string.substring(17, 20).trim();
        this.chainID = string.substring(21, 22).trim();
        this.resSeq = string.substring(22, 26).trim();
        this.iCode = string.substring(26, 27).trim();
        this.x = Float.valueOf(string.substring(30, 38).trim()).floatValue();
        this.y = Float.valueOf(string.substring(38, 46).trim()).floatValue();
        this.z = Float.valueOf(string.substring(46, 54).trim()).floatValue();
        this.occupancy = string.substring(54, 60).trim();
        this.tempFactor = string.substring(60, 66).trim();
        this.segID = string.substring(72, 76).trim();
        this.element = string.substring(76, 78).trim();
        this.charge = string.substring(78, 80).trim();
        this.buildNode();
    }
}

