/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.pdb;

import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import ncsa.j3d.loaders.pdb.Record;

public class PDBParser {
    protected Vector vector = new Vector();

    public Scene getGeometry() {
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(9);
        branchGroup.setBoundsAutoCompute(true);
        Enumeration enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            Record record = (Record)enumeration.nextElement();
            Node node = record.getNode();
            if (node == null) continue;
            branchGroup.addChild(node);
        }
        sceneBase.setSceneGroup(branchGroup);
        sceneBase.addDescription("PDB file");
        return sceneBase;
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            new PDBParser().parse(inputStreamReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(String.valueOf(stringArray[0]) + " not found.");
        }
        catch (IOException iOException) {
            System.out.println("PDBParser.main");
            System.out.println(iOException);
        }
    }

    public void parse(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            Record record;
            if (string.length() != 80 || (record = Record.subtype(string)) == null) continue;
            this.vector.addElement(record);
        }
    }
}

