/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.pdb;

import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.vecmath.Color3f;

public class AppearanceManager {
    static Hashtable hashtable;
    static String[] nameArray;
    static Color3f[] colorArray;

    static {
        nameArray = new String[]{"C", "O", "H", "N", "S", "P", "CL", "BR", "ZN", "NA", "FE", "CA"};
        colorArray = new Color3f[]{new Color3f(0.2f, 0.2f, 0.2f), new Color3f(1.0f, 0.0f, 0.0f), new Color3f(1.0f, 1.0f, 1.0f), new Color3f(0.0f, 0.6f, 1.0f), new Color3f(1.0f, 1.0f, 0.0f), new Color3f(1.0f, 0.5f, 0.0f), new Color3f(0.0f, 1.0f, 0.0f), new Color3f(0.2f, 0.1f, 0.1f), new Color3f(0.2f, 0.1f, 0.1f), new Color3f(0.0f, 0.0f, 1.0f), new Color3f(0.8f, 0.0f, 1.0f), new Color3f(0.7f, 0.7f, 0.7f)};
        hashtable = new Hashtable();
        int n = 0;
        while (n < nameArray.length && n < colorArray.length) {
            hashtable.put(nameArray[n], AppearanceManager.buildAppearance(colorArray[n]));
            ++n;
        }
    }

    protected static Appearance buildAppearance(Color3f color3f) {
        Appearance appearance = new Appearance();
        Material material = new Material();
        material.setLightingEnable(true);
        material.setShininess(25.0f);
        material.setDiffuseColor(color3f);
        color3f.scale(0.2f);
        material.setAmbientColor(color3f);
        color3f.scale(0.0f);
        material.setSpecularColor(color3f);
        material.setEmissiveColor(color3f);
        appearance.setMaterial(material);
        return appearance;
    }

    public static Appearance getAppearanceByElement(String string) {
        try {
            if (hashtable.containsKey(string)) {
                return (Appearance)hashtable.get(string);
            }
            Color3f color3f = new Color3f(0.8f, 0.2f, 0.9f);
            Appearance appearance = AppearanceManager.buildAppearance(color3f);
            hashtable.put(string, appearance);
            return appearance;
        }
        catch (Exception exception) {
            System.out.println("ncsa.j3d.loaders.pdb.AppearanceManager.getAppearanceByElement");
            System.out.println(exception);
            return null;
        }
    }
}

