/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.nff;

import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.geometry.Triangulator;
import java.io.Reader;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ncsa.util.ReaderTokenizer;

public class NFFLoader {
    private BranchGroup bg;
    private ReaderTokenizer fis;
    private boolean debug = false;
    private Appearance currentApp = new Appearance();
    private int polygons_total = 0;

    public BranchGroup LoadNFF(Reader reader) {
        this.bg = new BranchGroup();
        this.bg.setCapability(3);
        this.fis = new ReaderTokenizer(reader);
        TransformGroup transformGroup = new TransformGroup();
        this.bg.addChild((Node)transformGroup);
        this.parseFile();
        return this.bg;
    }

    private void addCylinder() {
        Vector3f vector3f = new Vector3f();
        this.fis.nextToken();
        vector3f.x = (float)this.fis.nval;
        this.fis.nextToken();
        vector3f.y = (float)this.fis.nval;
        this.fis.nextToken();
        vector3f.z = (float)this.fis.nval;
        this.fis.nextToken();
        float f = (float)this.fis.nval;
        Vector3f vector3f2 = new Vector3f();
        this.fis.nextToken();
        vector3f2.x = (float)this.fis.nval;
        this.fis.nextToken();
        vector3f2.y = (float)this.fis.nval;
        this.fis.nextToken();
        vector3f2.z = (float)this.fis.nval;
        this.fis.nextToken();
        float f2 = (float)this.fis.nval;
        Vector3f vector3f3 = new Vector3f();
        vector3f3.x = (vector3f2.x - vector3f.x) / 2.0f + vector3f.x;
        vector3f3.y = (vector3f2.y - vector3f.y) / 2.0f + vector3f.y;
        vector3f3.z = (vector3f2.z - vector3f.z) / 2.0f + vector3f.z;
        Vector3f vector3f4 = new Vector3f();
        vector3f4.sub((Tuple3f)vector3f2, (Tuple3f)vector3f);
        float f3 = vector3f4.length();
        vector3f4.normalize();
        Vector3f vector3f5 = new Vector3f();
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        Transform3D transform3D = new Transform3D();
        vector3f6 = new Vector3f(vector3f4);
        vector3f5.cross(vector3f4, new Vector3f(0.0f, 0.0f, 1.0f));
        float f4 = vector3f5.length();
        if (f4 != 0.0f) {
            vector3f5.z /= f4;
            vector3f5.x /= f4;
            vector3f5.y /= f4;
            vector3f7.cross(vector3f5, vector3f6);
        } else {
            vector3f5 = new Vector3f(vector3f4);
            vector3f7.cross(vector3f4, new Vector3f(0.0f, 1.0f, 0.0f));
            float f5 = vector3f7.length();
            vector3f7.x /= f5;
            vector3f7.y /= f5;
            vector3f7.z /= f5;
            vector3f6.cross(vector3f7, vector3f5);
            transform3D.rotZ(1.5707963267948966);
        }
        Transform3D transform3D2 = new Transform3D();
        Transform3D transform3D3 = new Transform3D(new Matrix4f(vector3f5.x, vector3f5.y, vector3f5.z, 0.0f, vector3f6.x, vector3f6.y, vector3f6.z, 0.0f, vector3f7.x, vector3f7.y, vector3f7.z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f));
        transform3D3.invert();
        transform3D2.mul(transform3D3);
        transform3D2.mul(transform3D);
        transform3D2.setTranslation(vector3f3);
        TransformGroup transformGroup = new TransformGroup(transform3D2);
        if (f == f2) {
            if (this.debug) {
                System.out.println("Adding a cylinder.");
            }
            int n = 1;
            if ((double)f < 0.0 && (double)f2 < 0.0) {
                n |= 4;
            }
            Cylinder cylinder = new Cylinder(f, f3, n, this.currentApp);
            transformGroup.addChild((Node)cylinder);
            this.bg.addChild((Node)transformGroup);
        } else {
            if (this.debug) {
                System.out.println("Adding a cone.");
            }
            if (this.debug && f2 != 0.0f) {
                System.out.println("Tapered cylinder encountered; cone will be drawn instead.");
            }
            int n = 1;
            if ((double)f <= 0.0 && (double)f2 <= 0.0) {
                n |= 4;
            }
            Cone cone = new Cone(f, f3, n, this.currentApp);
            transformGroup.addChild((Node)cone);
            this.bg.addChild((Node)transformGroup);
        }
    }

    private void addPolygon(boolean bl) {
        Triangulator triangulator;
        ++this.polygons_total;
        this.fis.nextToken();
        int n = (int)this.fis.nval;
        if (this.debug) {
            System.out.println("Polygon #" + this.polygons_total + ", number of vertices: " + n);
        }
        if (this.debug && bl) {
            System.out.println("Polygon patch.");
        }
        Point3d[] point3dArray = new Point3d[n];
        Vector3f[] vector3fArray = new Vector3f[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[]{n};
        int n2 = 0;
        while (n2 < n) {
            this.fis.nextToken();
            double d = this.fis.nval;
            this.fis.nextToken();
            double d2 = this.fis.nval;
            this.fis.nextToken();
            double d3 = this.fis.nval;
            point3dArray[n2] = new Point3d(d, d2, d3);
            if (bl) {
                this.fis.nextToken();
                d = this.fis.nval;
                this.fis.nextToken();
                d2 = this.fis.nval;
                this.fis.nextToken();
                d3 = this.fis.nval;
                vector3fArray[n2] = new Vector3f((float)d, (float)d2, (float)d3);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3dArray);
        geometryInfo.setCoordinateIndices(nArray);
        geometryInfo.setStripCounts(nArray3);
        if (bl) {
            geometryInfo.setNormals(vector3fArray);
            geometryInfo.setNormalIndices(nArray);
            triangulator = new Triangulator();
            triangulator.triangulate(geometryInfo);
        } else {
            triangulator = new Triangulator();
            triangulator.triangulate(geometryInfo);
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.generateNormals(geometryInfo);
        }
        triangulator = new Shape3D((Geometry)geometryInfo.getGeometryArray(), this.currentApp);
        this.bg.addChild((Node)triangulator);
    }

    private void addSphere() {
        int n = 1;
        if (this.debug) {
            System.out.println("Adding a sphere.");
        }
        this.fis.nextToken();
        float f = (float)this.fis.nval;
        this.fis.nextToken();
        float f2 = (float)this.fis.nval;
        this.fis.nextToken();
        float f3 = (float)this.fis.nval;
        this.fis.nextToken();
        float f4 = (float)this.fis.nval;
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(f, f2, f3));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Sphere sphere = new Sphere(f4, n, this.currentApp);
        transformGroup.addChild((Node)sphere);
        this.bg.addChild((Node)transformGroup);
    }

    private void parseFile() {
        boolean bl = false;
        boolean bl2 = false;
        if (this.debug) {
            System.out.println("Reading file...");
        }
        this.fis.nextToken();
        while (this.fis.ttype != -103 && !bl) {
            if (this.fis.ttype != -101) {
                bl = true;
                System.out.println("Token v, p, pp, f, b, l, c, or s expected, line #" + this.fis.lineno() + ".");
            } else {
                char c = this.fis.sval.charAt(0);
                bl2 = false;
                switch (c) {
                    case 'f': {
                        this.setAppearance();
                        break;
                    }
                    case 'b': {
                        this.setBackground();
                        break;
                    }
                    case 'l': {
                        this.setLightSource();
                        break;
                    }
                    case 'v': {
                        this.setView();
                        break;
                    }
                    case 'p': {
                        if (this.fis.sval.compareTo("pp") == 0) {
                            this.addPolygon(true);
                            break;
                        }
                        this.addPolygon(false);
                        break;
                    }
                    case 's': {
                        this.addSphere();
                        break;
                    }
                    case 'c': {
                        this.addCylinder();
                        break;
                    }
                    default: {
                        System.out.println("Unrecognized token \"" + c + '\"' + " encountered at line #" + this.fis.lineno() + ".");
                        bl = true;
                        break;
                    }
                }
            }
            this.fis.nextToken();
        }
        if (this.debug) {
            System.out.println("Done.");
        }
    }

    private void setAppearance() {
        this.fis.nextToken();
        float f = (float)this.fis.nval;
        this.fis.nextToken();
        float f2 = (float)this.fis.nval;
        this.fis.nextToken();
        float f3 = (float)this.fis.nval;
        this.fis.nextToken();
        float f4 = (float)this.fis.nval;
        this.fis.nextToken();
        float f5 = (float)this.fis.nval;
        this.fis.nextToken();
        float f6 = (float)this.fis.nval;
        this.fis.nextToken();
        float f7 = (float)this.fis.nval;
        this.fis.nextToken();
        float f8 = (float)this.fis.nval;
        if (((int)f4 != 0 || (int)f5 != 0 || (int)f6 != 0 || (int)f7 != 0 || (int)f8 != 0) && this.debug) {
            System.out.println("Complex attributes encountered (at line #" + this.fis.lineno() + ")");
        }
        Material material = new Material();
        if ((int)f4 != 0 || (int)f5 != 0) {
            if (this.debug) {
                System.out.println("Specular and diffuse components non-zero in file.");
            }
            material.setDiffuseColor(f4 * f, f4 * f2, f4 * f3);
            material.setSpecularColor(f5 * f, f5 * f2, f5 * f3);
            material.setShininess(f6 * 128.0f);
            material.setEmissiveColor(f7 * f, f7 * f2, f7 * f3);
        } else {
            material.setDiffuseColor(0.3f * f, 0.3f * f2, 0.3f * f3);
            material.setAmbientColor(0.7f * f, 0.7f * f2, 0.7f * f3);
        }
        this.currentApp = new Appearance();
        this.currentApp.setMaterial(material);
    }

    private void setBackground() {
        this.fis.nextToken();
        float f = (float)this.fis.nval;
        this.fis.nextToken();
        float f2 = (float)this.fis.nval;
        this.fis.nextToken();
        float f3 = (float)this.fis.nval;
        Background background = new Background(f, f2, f3);
        this.bg.addChild((Node)background);
    }

    private void setLightSource() {
        this.fis.nextToken();
        float f = (float)this.fis.nval;
        this.fis.nextToken();
        float f2 = (float)this.fis.nval;
        this.fis.nextToken();
        float f3 = (float)this.fis.nval;
        PointLight pointLight = new PointLight();
        pointLight.setPosition(f, f2, f3);
        this.fis.nextToken();
        if (this.fis.ttype != -102) {
            this.fis.pushBack();
        } else {
            float f4 = (float)this.fis.nval;
            this.fis.nextToken();
            float f5 = (float)this.fis.nval;
            this.fis.nextToken();
            float f6 = (float)this.fis.nval;
            pointLight.setColor(new Color3f(f4, f5, f6));
        }
        this.bg.addChild((Node)pointLight);
    }

    private void setView() {
        float f;
        float f2;
        float f3;
        this.fis.nextToken();
        if (this.fis.sval.compareTo("from") == 0) {
            this.fis.nextToken();
            f3 = (float)this.fis.nval;
            this.fis.nextToken();
            f2 = (float)this.fis.nval;
            this.fis.nextToken();
            f = (float)this.fis.nval;
            this.fis.nextToken();
        }
        if (this.fis.sval.compareTo("at") == 0) {
            this.fis.nextToken();
            f3 = (float)this.fis.nval;
            this.fis.nextToken();
            f2 = (float)this.fis.nval;
            this.fis.nextToken();
            f = (float)this.fis.nval;
            this.fis.nextToken();
        }
        if (this.fis.sval.compareTo("up") == 0) {
            this.fis.nextToken();
            f3 = (float)this.fis.nval;
            this.fis.nextToken();
            f2 = (float)this.fis.nval;
            this.fis.nextToken();
            f = (float)this.fis.nval;
            this.fis.nextToken();
        }
        if (this.fis.sval.compareTo("angle") == 0) {
            this.fis.nextToken();
            f3 = (float)this.fis.nval;
            this.fis.nextToken();
        }
        if (this.fis.sval.compareTo("hither") == 0) {
            this.fis.nextToken();
            f3 = (float)this.fis.nval;
            this.fis.nextToken();
        }
        if (this.fis.sval.compareTo("resolution") == 0) {
            this.fis.nextToken();
            f3 = (float)this.fis.nval;
            this.fis.nextToken();
            f2 = (float)this.fis.nval;
            this.fis.nextToken();
        }
        this.fis.pushBack();
    }
}

