/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.loadIOB;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import ncsa.j3d.loaders.loadIOB.AppearanceList;

class ObjectList {
    private Nodes Head = null;
    private Nodes Current = null;

    private Nodes FindName(int n) {
        if (this.Current != null && n == this.Current.id) {
            return this.Current;
        }
        this.Current = this.Head;
        while (this.Current != null && n != this.Current.id) {
            this.Current = this.Current.next;
        }
        if (this.Current == null) {
            this.addObject(n);
        }
        return this.Current;
    }

    public int addObject(int n) {
        this.Current = this.Head = new Nodes(null, null, null, n, this.Head, 0);
        return this.Current.id;
    }

    public BranchGroup createBranchGroup(AppearanceList appearanceList) {
        AppearanceList appearanceList2 = appearanceList;
        BranchGroup branchGroup = new BranchGroup();
        Nodes nodes = this.Head;
        while (nodes != null) {
            Shape3D shape3D = null;
            if (nodes.point != null) {
                shape3D = this.createBranchGroup(nodes, appearanceList2);
            }
            if (shape3D != null) {
                branchGroup.addChild((Node)shape3D);
            }
            nodes = nodes.next;
        }
        return branchGroup;
    }

    private Shape3D createBranchGroup(Nodes nodes, AppearanceList appearanceList) {
        AppearanceList appearanceList2 = appearanceList;
        if (nodes.faces != null && nodes.edges != null && nodes.faces.length > 0 && nodes.edges.length > 0) {
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setCoordinates(nodes.point);
            int[] nArray = new int[nodes.faces.length * 3];
            int[] nArray2 = new int[nodes.faces.length];
            int n = 0;
            while (n < nodes.faces.length) {
                if (nodes.faces[n][0] < nodes.edges.length && nodes.faces[n][1] < nodes.edges.length) {
                    nArray[3 * n] = nodes.edges[nodes.faces[n][0]][1];
                    nArray[3 * n + 1] = nodes.edges[nodes.faces[n][0]][0];
                    nArray[3 * n + 2] = nodes.edges[nodes.faces[n][1]][0] == nodes.edges[nodes.faces[n][0]][0] || nodes.edges[nodes.faces[n][1]][0] == nodes.edges[nodes.faces[n][0]][1] ? nodes.edges[nodes.faces[n][1]][1] : nodes.edges[nodes.faces[n][1]][0];
                    nArray2[n] = 3;
                } else {
                    nArray[3 * n] = nArray[3 * n - 3];
                    nArray[3 * n + 1] = nArray[3 * n - 3 + 1];
                    nArray[3 * n + 2] = nArray[3 * n - 3 + 2];
                    nArray2[n] = 3;
                }
                ++n;
            }
            geometryInfo.setCoordinateIndices(nArray);
            geometryInfo.setStripCounts(nArray2);
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.generateNormals(geometryInfo);
            return new Shape3D((Geometry)geometryInfo.getGeometryArray(), appearanceList2.getAppearance(nodes.id));
        }
        return null;
    }

    public int[][] getEdges(int n) {
        return this.FindName((int)n).edges;
    }

    public int[][] getFaces(int n) {
        return this.FindName((int)n).faces;
    }

    public int getNFaces(int n) {
        return this.FindName((int)n).nfaces;
    }

    public Point3f[] getPoint(int n) {
        return this.FindName((int)n).point;
    }

    public int setEdges(int n, int[][] nArray) {
        this.FindName((int)n).edges = nArray;
        return this.Current.id;
    }

    public int setFaces(int n, int[][] nArray) {
        this.FindName((int)n).faces = nArray;
        return this.Current.id;
    }

    public int setMaterial(int n, String string) {
        this.FindName((int)n).material = string;
        return this.Current.id;
    }

    public int setNFaces(int n, int n2) {
        this.FindName((int)n).nfaces = n2;
        return this.Current.id;
    }

    public int setPoint(int n, Point3f[] point3fArray) {
        this.FindName((int)n).point = point3fArray;
        return this.Current.id;
    }

    class Nodes {
        public String material;
        public Point3f[] point;
        public int[][] edges;
        public int[][] faces;
        public int nfaces;
        public int id;
        public Nodes next;

        Nodes(Point3f[] point3fArray, int[][] nArray, int[][] nArray2, int n, Nodes nodes, int n2) {
            this.point = point3fArray;
            this.edges = nArray;
            this.faces = nArray2;
            this.id = n;
            this.next = nodes;
            this.material = null;
            this.nfaces = n2;
        }
    }
}

