/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.loadIOB;

import java.io.IOException;
import java.io.Reader;
import javax.media.j3d.BranchGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.loadIOB.AppearanceList;
import ncsa.j3d.loaders.loadIOB.Chunk;
import ncsa.j3d.loaders.loadIOB.ObjectList;

public class LoaderIOB {
    private AppearanceList al;
    private ObjectList ol;
    private static int objID = 0;

    public BranchGroup LoadIOB(Reader reader) {
        this.al = new AppearanceList();
        this.ol = new ObjectList();
        this.readBytes(reader, 12);
        this.mainCall(reader, 1);
        BranchGroup branchGroup = this.ol.createBranchGroup(this.al);
        return branchGroup;
    }

    private int descCall(Reader reader, int n, int n2) {
        int n3 = n;
        this.al.addAppearance(n2);
        this.ol.addObject(n2);
        while (n3 > 0) {
            Chunk chunk = this.readChunk(reader);
            int n4 = 0;
            switch (chunk.name.charAt(0)) {
                case 'C': {
                    if (chunk.name.compareTo("COLR") != 0) break;
                    Color3f color3f = this.readColor(reader);
                    this.al.setAmbient(n2, new Color3f(color3f.x * 0.4f, color3f.y * 0.4f, color3f.z * 0.4f));
                    this.al.setDiffuse(n2, new Color3f(color3f.x * 0.7f, color3f.y * 0.7f, color3f.z * 0.7f));
                    this.al.setEmissive(n2, this.al.BLACK);
                    this.al.setSpecular(n2, color3f);
                    n4 = chunk.length;
                    break;
                }
                case 'E': {
                    if (chunk.name.compareTo("EDGE") != 0) break;
                    int n5 = this.readBytes(reader, 2);
                    Object object = new int[n5][2];
                    int n6 = 0;
                    while (n6 < n5) {
                        object[n6][0] = (Point3f)this.readBytes(reader, 2);
                        object[n6][1] = (Point3f)this.readBytes(reader, 2);
                        ++n6;
                    }
                    this.ol.setEdges(n2, (int[][])object);
                    n4 = chunk.length;
                    break;
                }
                case 'F': {
                    if (chunk.name.compareTo("FACE") != 0) break;
                    int n7 = this.readBytes(reader, 2);
                    Object object = new int[n7][3];
                    int n6 = 0;
                    while (n6 < n7) {
                        object[n6][0] = (Point3f)this.readBytes(reader, 2);
                        object[n6][1] = (Point3f)this.readBytes(reader, 2);
                        object[n6][2] = (Point3f)this.readBytes(reader, 2);
                        ++n6;
                    }
                    this.ol.setFaces(n2, (int[][])object);
                    n4 = chunk.length;
                    break;
                }
                case 'P': {
                    if (chunk.name.compareTo("PNTS") != 0) break;
                    int n8 = this.readBytes(reader, 2);
                    Object object = new Point3f[n8];
                    int n6 = 0;
                    while (n6 < n8) {
                        object[n6] = this.readPoint(reader);
                        ++n6;
                    }
                    this.ol.setPoint(n2, (Point3f[])object);
                    n4 = chunk.length;
                    break;
                }
                case 'T': {
                    if (chunk.name.compareTo("TRAN") != 0) break;
                    Color3f color3f = this.readColor(reader);
                    this.al.setTransparency(n2, this.al.getSpecular((int)n2).x / color3f.x);
                    n4 = chunk.length;
                    break;
                }
            }
            if (chunk.length - n4 > 0) {
                this.readBytes(reader, chunk.length - n4);
            }
            n3 -= chunk.length + 8;
            if (chunk.length % 2 != 1) continue;
            this.readBytes(reader, 1);
            --n3;
        }
        return n3;
    }

    private int mainCall(Reader reader, int n) {
        int n2 = n;
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            if (chunk.name.compareTo("OBJ ") == 0) {
                this.objCall(reader, chunk.length);
            } else {
                this.readBytes(reader, chunk.length);
            }
            n2 -= chunk.length + 8;
            if (chunk.length % 2 != 1) continue;
            this.readBytes(reader, 1);
            --n2;
        }
        return n2;
    }

    private int objCall(Reader reader, int n) {
        int n2 = n;
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            if (chunk.name.compareTo("DESC") == 0) {
                this.descCall(reader, chunk.length, objID++);
            } else {
                this.readBytes(reader, chunk.length);
            }
            n2 -= chunk.length + 8;
            if (chunk.length % 2 != 1) continue;
            this.readBytes(reader, 1);
            --n2;
        }
        return n2;
    }

    private Chunk printChunk(Chunk chunk) {
        System.out.print(String.valueOf(chunk.name) + " -- " + chunk.length);
        return chunk;
    }

    private int readBytes(Reader reader, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                n2 = reader.read() + (n2 << 8);
            }
            catch (IOException iOException) {
                System.err.println("Error with file.\n" + iOException.toString());
                System.exit(1);
            }
            ++n3;
        }
        return n2;
    }

    private char readChar(Reader reader) {
        return (char)this.readBytes(reader, 1);
    }

    private Chunk readChunk(Reader reader) {
        String string = this.readString(reader, 4);
        int n = this.readBytes(reader, 4);
        return new Chunk(string, n);
    }

    private Color3f readColor(Reader reader) {
        this.readBytes(reader, 1);
        return new Color3f((float)this.readBytes(reader, 1) / 256.0f, (float)this.readBytes(reader, 1) / 256.0f, (float)this.readBytes(reader, 1) / 256.0f);
    }

    private float readFloat(Reader reader) {
        return Float.intBitsToFloat(this.readBytes(reader, 4));
    }

    private Point3f readPoint(Reader reader) {
        return new Point3f((float)this.readBytes(reader, 4) / 65536.0f, (float)this.readBytes(reader, 4) / 65536.0f, (float)this.readBytes(reader, 4) / 65536.0f);
    }

    private String readString(Reader reader) {
        String string = new String();
        char c = this.readChar(reader);
        while (c > '\u0000') {
            string = String.valueOf(string) + (char)c;
            c = this.readChar(reader);
        }
        return string;
    }

    private String readString(Reader reader, int n) {
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.readChar(reader);
            ++n2;
        }
        return string;
    }

    private Vector3f readVector(Reader reader) {
        return new Vector3f((float)this.readBytes(reader, 4) / 65536.0f, (float)this.readBytes(reader, 4) / 65536.0f, (float)this.readBytes(reader, 4) / 65536.0f);
    }

    private void skipBytes(Reader reader, int n) {
        int n2 = 0;
        while (n2 < n) {
            try {
                reader.read();
            }
            catch (IOException iOException) {
                System.err.println("Error with file.\n" + iOException.toString());
                System.exit(1);
            }
            ++n2;
        }
    }
}

