/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.loadCOB;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.loadCOB.Poly;

class ObjectList {
    private Nodes Head = null;
    private Nodes Current = null;

    public Poly Current() {
        if (this.Current != null) {
            return this.Current.pgon;
        }
        return null;
    }

    public int CurrentId() {
        if (this.Current == null) {
            return -1;
        }
        return this.Current.id;
    }

    private Nodes FindName(int n) {
        if (this.Current != null && n == this.Current.id) {
            return this.Current;
        }
        this.Current = this.Head;
        while (this.Current != null && n != this.Current.id) {
            this.Current = this.Current.next;
        }
        if (this.Current == null) {
            this.addObject(n);
        }
        return this.Current;
    }

    public Poly Next() {
        if (this.Current != null) {
            this.Current = this.Current.next;
        }
        return this.Current();
    }

    public Poly Start() {
        this.Current = this.Head;
        return this.Current();
    }

    public int addObject(int n) {
        this.Current = this.Head = new Nodes(new Poly(), this.Head, n);
        return this.Current.id;
    }

    public Vector3f[] getAxes(int n) {
        return this.FindName((int)n).pgon.Axes;
    }

    public Point3f getCenter(int n) {
        return this.FindName((int)n).pgon.center;
    }

    public Matrix4f getCurrentPos(int n) {
        return this.FindName((int)n).pgon.currentPos;
    }

    public int getDupCount(int n) {
        return this.FindName((int)n).pgon.dupCount;
    }

    public int[][] getFaces(int n) {
        return this.FindName((int)n).pgon.Faces;
    }

    public int getMaterial(int n) {
        return this.FindName((int)n).pgon.Material;
    }

    public String getName(int n) {
        return this.FindName((int)n).pgon.name;
    }

    public Poly getPoly(int n) {
        return this.FindName((int)n).pgon;
    }

    public Point3f[] getVerticies(int n) {
        return this.FindName((int)n).pgon.Verticies;
    }

    public boolean isDone() {
        return this.Current == null;
    }

    public int setAxes(int n, Vector3f[] vector3fArray) {
        this.FindName((int)n).pgon.Axes = vector3fArray;
        return this.Current.id;
    }

    public int setCenter(int n, Point3f point3f) {
        this.FindName((int)n).pgon.center = point3f;
        return this.Current.id;
    }

    public int setCurrentPos(int n, Matrix4f matrix4f) {
        this.FindName((int)n).pgon.currentPos = matrix4f;
        return this.Current.id;
    }

    public int setDupCount(int n, int n2) {
        this.FindName((int)n).pgon.dupCount = n2;
        return this.Current.id;
    }

    public int setFaces(int n, int[][] nArray) {
        this.FindName((int)n).pgon.Faces = nArray;
        return this.Current.id;
    }

    public int setMaterial(int n, int n2) {
        this.FindName((int)n).pgon.Material = n2;
        return this.Current.id;
    }

    public int setName(int n, String string) {
        this.FindName((int)n).pgon.name = string;
        return this.Current.id;
    }

    public int setPoly(int n, Poly poly) {
        this.FindName((int)n).pgon = poly;
        return this.Current.id;
    }

    public int setVerticies(int n, Point3f[] point3fArray) {
        this.FindName((int)n).pgon.Verticies = point3fArray;
        return this.Current.id;
    }

    class Nodes {
        public Poly pgon;
        public int id;
        public Nodes next;

        Nodes(Poly poly, Nodes nodes, int n) {
            this.pgon = poly;
            this.next = nodes;
            this.id = n;
        }
    }
}

