/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.loadCOB;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Triangulator;
import java.io.Reader;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import ncsa.j3d.loaders.loadCOB.AppearanceList;
import ncsa.j3d.loaders.loadCOB.Chunk;
import ncsa.j3d.loaders.loadCOB.FileReader;
import ncsa.j3d.loaders.loadCOB.ObjectList;
import ncsa.j3d.loaders.loadCOB.Poly;

public class LoaderCOB {
    public BranchGroup CreateBranchGroup(ObjectList objectList, AppearanceList appearanceList) {
        BranchGroup branchGroup = new BranchGroup();
        Poly poly = objectList.Start();
        while (!objectList.isDone()) {
            branchGroup.addChild((Node)this.CreateBranchGroup(poly, appearanceList, objectList.CurrentId()));
            poly = objectList.Next();
        }
        return branchGroup;
    }

    public TransformGroup CreateBranchGroup(Poly poly, AppearanceList appearanceList, int n) {
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(poly.Verticies);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < poly.Faces.length) {
            if (poly.Faces[n4] != null) {
                ++n2;
                n3 += poly.Faces[n4].length;
            }
            ++n4;
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n3];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < poly.Faces.length) {
            if (poly.Faces[n7] != null) {
                nArray[n5] = poly.Faces[n7].length;
                ++n5;
                int n8 = 0;
                while (n8 < poly.Faces[n7].length) {
                    nArray2[n6] = poly.Faces[n7][poly.Faces[n7].length - (n8 + 1)];
                    ++n6;
                    ++n8;
                }
            }
            ++n7;
        }
        geometryInfo.setCoordinateIndices(nArray2);
        geometryInfo.setStripCounts(nArray);
        Triangulator triangulator = new Triangulator();
        triangulator.triangulate(geometryInfo);
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        BranchGroup branchGroup = new BranchGroup();
        Transform3D transform3D = new Transform3D(poly.currentPos);
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)branchGroup);
        Appearance appearance = appearanceList.getAppearance(n + poly.Material);
        branchGroup.addChild((Node)new Shape3D((Geometry)geometryInfo.getGeometryArray(), appearance));
        return transformGroup;
    }

    public BranchGroup LoadCOB(Reader reader) {
        FileReader fileReader = new FileReader(reader);
        AppearanceList appearanceList = new AppearanceList();
        ObjectList objectList = new ObjectList();
        boolean bl = this.readHeader(fileReader);
        Chunk chunk = fileReader.readChunk(bl);
        while (chunk.type.compareTo("END ") != 0 && chunk.id >= 0) {
            if (chunk.type.compareTo("PolH") == 0) {
                objectList.setPoly(chunk.id, fileReader.readPolH(bl));
            } else if (chunk.type.compareTo("Mat1") == 0) {
                appearanceList = fileReader.readMaterial(appearanceList, bl, chunk.pid, chunk.length);
            } else {
                fileReader.skipBytes(bl ? chunk.length : chunk.length - 1);
            }
            chunk = fileReader.readChunk(bl);
        }
        BranchGroup branchGroup = this.CreateBranchGroup(objectList, appearanceList);
        return branchGroup;
    }

    private boolean readHeader(FileReader fileReader) {
        fileReader.readBytes(15);
        boolean bl = fileReader.readChar() == 'B';
        fileReader.readBytes(16);
        return bl;
    }
}

