/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.loadCOB;

import java.io.IOException;
import java.io.Reader;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.j3d.loaders.loadCOB.AppearanceList;
import ncsa.j3d.loaders.loadCOB.Chunk;
import ncsa.j3d.loaders.loadCOB.Poly;

public class FileReader {
    private Reader reader;

    public FileReader(Reader reader) {
        this.reader = reader;
    }

    public float ToFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public int ToInt(String string) {
        return Integer.parseInt(string);
    }

    public int readBytes(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                n2 += this.reader.read() << 8 * n3;
            }
            catch (IOException iOException) {
                System.err.println("Error with file.\n" + iOException.toString());
                System.exit(1);
            }
            ++n3;
        }
        return n2;
    }

    public char readChar() {
        return (char)this.readBytes(1);
    }

    public Chunk readChunk(boolean bl) {
        Chunk chunk = new Chunk();
        if (bl) {
            chunk.type = this.readString(4);
            this.skipBytes(4);
            chunk.id = this.readBytes(4);
            chunk.pid = this.readBytes(4);
            chunk.length = this.readBytes(4);
        } else {
            chunk.type = this.readString(4);
            this.readString();
            this.readString();
            chunk.id = this.readStringToInt();
            this.readString();
            chunk.pid = this.readStringToInt();
            this.readString();
            chunk.length = this.readStringToInt();
        }
        return chunk;
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readBytes(4));
    }

    public AppearanceList readMaterial(AppearanceList appearanceList, boolean bl, int n, int n2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        int n3;
        AppearanceList appearanceList2 = appearanceList;
        if (bl) {
            n3 = this.readBytes(2) + n;
            this.skipBytes(3);
            f7 = this.readFloat();
            f6 = this.readFloat();
            f5 = this.readFloat();
            f4 = this.readFloat();
            f3 = this.readFloat();
            f2 = this.readFloat();
            f = this.readFloat();
            this.skipBytes(n2 - 33);
        } else {
            int n4 = 61;
            this.readString();
            String string = this.readString();
            n4 += string.length();
            n3 = this.ToInt(string) + n;
            this.readString();
            n4 += this.readString().length();
            this.readString();
            n4 += this.readString().length();
            this.readString();
            string = this.readToChar(',', false);
            n4 += string.length();
            f7 = this.ToFloat(string);
            string = this.readToChar(',', false);
            n4 += string.length();
            f6 = this.ToFloat(string);
            string = this.readToChar(',', false);
            n4 += string.length();
            f5 = this.ToFloat(string);
            this.readString();
            string = this.readString();
            n4 += string.length();
            f4 = this.ToFloat(string);
            this.readString();
            string = this.readString();
            n4 += string.length();
            f3 = this.ToFloat(string);
            this.readString();
            string = this.readString();
            n4 += string.length();
            f2 = this.ToFloat(string);
            this.readString();
            string = this.readString();
            n4 += string.length();
            f = this.ToFloat(string);
            this.readString();
            this.skipBytes(n2 - (n4 += this.readString().length()));
        }
        appearanceList2.addAppearance(n3);
        appearanceList2.setTransparency(n3, f4);
        appearanceList2.setAmbient(n3, new Color3f(f7 * f3, f6 * f3, f5 * f3));
        appearanceList2.setDiffuse(n3, new Color3f(f7, f6, f5));
        appearanceList2.setSpecular(n3, new Color3f(f7 * f2, f6 * f2, f5 * f2));
        appearanceList2.setShininess(n3, f);
        return appearanceList2;
    }

    public Poly readPolH(boolean bl) {
        Poly poly = new Poly();
        if (bl) {
            poly.dupCount = this.readBytes(2);
            poly.name = this.readString(this.readBytes(2));
            poly.center = new Point3f(this.readFloat(), this.readFloat(), this.readFloat());
            poly.Axes[0] = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
            poly.Axes[1] = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
            poly.Axes[2] = new Vector3f(this.readFloat(), this.readFloat(), this.readFloat());
            poly.currentPos = new Matrix4f(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), 0.0f, 0.0f, 0.0f, 1.0f);
            int n = this.readBytes(4);
            poly.Verticies = new Point3f[n];
            int n2 = 0;
            while (n2 < n) {
                poly.Verticies[n2] = new Point3f(this.readFloat(), this.readFloat(), this.readFloat());
                ++n2;
            }
            n = this.readBytes(4);
            int n3 = 0;
            while (n3 < n) {
                this.skipBytes(8);
                ++n3;
            }
            n = this.readBytes(4);
            poly.Faces = new int[n][];
            int n4 = 0;
            while (n4 < n) {
                int n5;
                int n6;
                int n7 = this.readBytes(1);
                if ((n7 & 8) != 8) {
                    n6 = this.readBytes(2);
                    poly.Material = this.readBytes(2);
                    poly.Faces[n4] = new int[n6];
                    n5 = 0;
                    while (n5 < n6) {
                        poly.Faces[n4][n5] = this.readBytes(4);
                        if (poly.Faces[n4][n5] < 0) {
                            poly.Faces[n4] = null;
                            return poly;
                        }
                        this.skipBytes(4);
                        ++n5;
                    }
                } else {
                    n6 = this.readBytes(2);
                    n5 = 0;
                    while (n5 < n6) {
                        this.skipBytes(8);
                        ++n5;
                    }
                }
                ++n4;
            }
        } else {
            this.readString();
            String string = this.readToChar(',', true);
            while (string.charAt(string.length() - 1) == ' ') {
                string = String.valueOf(string) + this.readToChar(',', true);
            }
            if (string.charAt(string.length() - 1) == ',') {
                poly.dupCount = this.readStringToInt();
            }
            poly.name = string.substring(0, string.length() - 1);
            this.readString();
            poly.center = new Point3f(this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat());
            this.readString();
            this.readString();
            poly.Axes[0] = new Vector3f(this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat());
            this.readString();
            this.readString();
            poly.Axes[1] = new Vector3f(this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat());
            this.readString();
            this.readString();
            poly.Axes[2] = new Vector3f(this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat());
            this.readString();
            poly.currentPos = new Matrix4f(this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat());
            this.readString();
            this.readString();
            int n = this.readStringToInt();
            poly.Verticies = new Point3f[n];
            int n8 = 0;
            while (n8 < n) {
                poly.Verticies[n8] = new Point3f(this.readStringToFloat(), this.readStringToFloat(), this.readStringToFloat());
                ++n8;
            }
            this.readString();
            this.readString();
            n = this.readStringToInt();
            int n9 = 0;
            while (n9 < n) {
                this.readString();
                this.readString();
                ++n9;
            }
            this.readString();
            n = this.readStringToInt();
            poly.Faces = new int[n][];
            int n10 = 0;
            while (n10 < n) {
                int n11;
                int n12;
                if (this.readString().compareTo("Face") == 0) {
                    this.readString();
                    n12 = this.readStringToInt();
                    this.readString();
                    n11 = this.readStringToInt();
                    this.readString();
                    poly.Material = this.readStringToInt();
                    poly.Faces[n10] = new int[n12];
                    int n13 = 0;
                    while (n13 < n12) {
                        this.readToChar('<', false);
                        poly.Faces[n10][n13] = Integer.parseInt(this.readToChar(',', false));
                        this.readString();
                        ++n13;
                    }
                } else {
                    this.readString();
                    n12 = this.readStringToInt();
                    n11 = 0;
                    while (n11 < n12) {
                        this.readString();
                        ++n11;
                    }
                }
                ++n10;
            }
            this.skipBytes(1);
        }
        return poly;
    }

    public String readString() {
        String string = new String();
        char c = this.readChar();
        while (c <= ' ') {
            c = this.readChar();
        }
        while (c > ' ' && c < '\u0100') {
            string = String.valueOf(string) + (char)c;
            c = this.readChar();
        }
        return string;
    }

    public String readString(int n) {
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.readChar();
            ++n2;
        }
        return string;
    }

    public float readStringToFloat() {
        return Float.valueOf(this.readString()).floatValue();
    }

    public float readStringToFloat(char c) {
        return Float.valueOf(this.readToChar(c, false)).floatValue();
    }

    public int readStringToInt() {
        return Integer.parseInt(this.readString());
    }

    public String readToChar(char c, boolean bl) {
        String string = new String();
        char c2 = this.readChar();
        while (c2 <= ' ') {
            c2 = this.readChar();
        }
        while (c2 > ' ' && c2 < '\u0100' && c2 != c) {
            string = String.valueOf(string) + (char)c2;
            c2 = this.readChar();
        }
        if (bl) {
            string = String.valueOf(string) + (char)c2;
        }
        return string;
    }

    public void skipBytes(int n) {
        int n2 = 0;
        while (n2 < n) {
            try {
                this.reader.read();
            }
            catch (IOException iOException) {
                System.err.println("Error with file.\n" + iOException.toString());
                System.exit(1);
            }
            ++n2;
        }
    }
}

