/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.load3ds;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import ncsa.j3d.loaders.load3ds.AppearanceList;
import ncsa.j3d.loaders.load3ds.Face;
import ncsa.j3d.loaders.load3ds.Mesh;

class ObjectList {
    private Nodes Head = null;
    private Nodes Current = null;

    private Nodes FindName(String string) {
        if (string == null) {
            string = new String("");
        }
        if (this.Current != null && string.compareTo(this.Current.name) == 0) {
            return this.Current;
        }
        this.Current = this.Head;
        while (this.Current != null && string.compareTo(this.Current.name) != 0) {
            this.Current = this.Current.next;
        }
        if (this.Current == null) {
            this.addObject(string);
        }
        return this.Current;
    }

    public String addObject(String string) {
        this.Current = this.Head = new Nodes(null, null, null, null, string, this.Head, 0);
        return this.Current.name;
    }

    public BranchGroup createBranchGroup(AppearanceList appearanceList, boolean bl) {
        if (bl) {
            System.out.print("[");
        }
        AppearanceList appearanceList2 = appearanceList;
        BranchGroup branchGroup = new BranchGroup();
        Nodes nodes = this.Head;
        while (nodes != null) {
            Shape3D shape3D;
            if (bl) {
                System.out.print("(" + nodes.name + ", " + nodes.point.length + ")");
            }
            if ((shape3D = this.createBranchGroup(nodes, appearanceList2)) != null) {
                branchGroup.addChild((Node)shape3D);
            }
            nodes = nodes.next;
        }
        if (bl) {
            System.out.print("]");
        }
        return branchGroup;
    }

    private Shape3D createBranchGroup(Nodes nodes, AppearanceList appearanceList) {
        AppearanceList appearanceList2 = appearanceList;
        if (nodes.faceArray.length >= 3) {
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setCoordinates(nodes.point);
            int[] nArray = new int[nodes.faceArray.length * 3];
            int[] nArray2 = new int[nodes.faceArray.length];
            int n = 0;
            while (n < nodes.faceArray.length) {
                nArray[3 * n] = nodes.faceArray[n].vertex[0];
                nArray[3 * n + 1] = nodes.faceArray[n].vertex[1];
                nArray[3 * n + 2] = nodes.faceArray[n].vertex[2];
                nArray2[n] = 3;
                ++n;
            }
            geometryInfo.setCoordinateIndices(nArray);
            geometryInfo.setStripCounts(nArray2);
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.generateNormals(geometryInfo);
            return new Shape3D((Geometry)geometryInfo.getGeometryArray(), appearanceList2.getAppearance(nodes.material));
        }
        return null;
    }

    public Face[] getFaces(String string) {
        return this.FindName((String)string).faceArray;
    }

    public int[] getFlags(String string) {
        return this.FindName((String)string).flags;
    }

    public Mesh getMesh(String string) {
        return this.FindName((String)string).mesh;
    }

    public int getNFaces(String string) {
        return this.FindName((String)string).nfaces;
    }

    public Point3f[] getPoint(String string) {
        return this.FindName((String)string).point;
    }

    public String setFaces(String string, Face[] faceArray) {
        this.FindName((String)string).faceArray = faceArray;
        return this.Current.name;
    }

    public String setFlags(String string, int[] nArray) {
        this.FindName((String)string).flags = nArray;
        return this.Current.name;
    }

    public String setMaterial(String string, String string2) {
        this.FindName((String)string).material = string2;
        return this.Current.name;
    }

    public String setMesh(String string, Mesh mesh) {
        this.FindName((String)string).mesh = mesh;
        return this.Current.name;
    }

    public String setNFaces(String string, int n) {
        this.FindName((String)string).nfaces = n;
        return this.Current.name;
    }

    public String setPoint(String string, Point3f[] point3fArray) {
        this.FindName((String)string).point = point3fArray;
        return this.Current.name;
    }

    class Nodes {
        public String material;
        public Point3f[] point;
        public int[] flags;
        public Mesh mesh;
        public Face[] faceArray;
        public int nfaces;
        public String name;
        public Nodes next;

        Nodes(Point3f[] point3fArray, int[] nArray, Mesh mesh, Face[] faceArray, String string, Nodes nodes, int n) {
            this.point = point3fArray;
            this.flags = nArray;
            this.mesh = mesh;
            this.faceArray = faceArray;
            this.name = string;
            this.next = nodes;
            this.material = null;
            this.nfaces = n;
        }
    }
}

