/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.load3ds;

import java.io.IOException;
import java.io.Reader;
import javax.media.j3d.BranchGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import ncsa.j3d.loaders.load3ds.AppearanceList;
import ncsa.j3d.loaders.load3ds.Chunk;
import ncsa.j3d.loaders.load3ds.Face;
import ncsa.j3d.loaders.load3ds.Mesh;
import ncsa.j3d.loaders.load3ds.ObjectList;

public class Loader3ds {
    private AppearanceList al;
    private ObjectList ol;
    private boolean progress = false;

    public BranchGroup Load3ds(Reader reader, boolean bl) {
        this.progress = bl;
        this.al = new AppearanceList();
        this.ol = new ObjectList();
        Chunk chunk = this.readChunk(reader);
        if (chunk.id == 19789) {
            this.Load3dsMain(reader, bl, chunk.length - 6);
        }
        BranchGroup branchGroup = this.ol.createBranchGroup(this.al, this.progress);
        if (this.progress) {
            System.err.println();
        }
        return branchGroup;
    }

    private void Load3dsFaceArray(Reader reader, boolean bl, int n, String string) {
        if (this.progress) {
            System.out.print(":");
        }
        int n2 = this.readBytes(reader, 2);
        int n3 = n - 2;
        this.ol.setNFaces(string, n2);
        Face[] faceArray = new Face[n2];
        int n4 = 0;
        while (n4 < n2) {
            faceArray[n4] = new Face();
            faceArray[n4].vertex[0] = this.readBytes(reader, 2);
            faceArray[n4].vertex[1] = this.readBytes(reader, 2);
            faceArray[n4].vertex[2] = this.readBytes(reader, 2);
            faceArray[n4].flags = this.readBytes(reader, 2);
            n3 -= 8;
            ++n4;
        }
        boolean bl2 = false;
        if (n3 > 0) {
            Chunk chunk = this.readChunk(reader);
            n3 -= 6;
            switch (chunk.id) {
                case 16688: {
                    String string2 = this.readString(reader);
                    bl2 = true;
                    this.ol.setMaterial(string, string2);
                    this.skipBytes(reader, n3 - string2.length() - 1);
                    break;
                }
                default: {
                    this.skipBytes(reader, n3);
                    break;
                }
            }
        }
        this.ol.setFaces(string, faceArray);
        if (this.progress) {
            System.out.print(":");
        }
    }

    private void Load3dsMData(Reader reader, boolean bl, int n) {
        if (this.progress) {
            System.out.print("[");
        }
        int n2 = n;
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            switch (chunk.id) {
                case 16384: {
                    this.Load3dsObject(reader, bl, chunk.length - 6);
                    break;
                }
                case 45055: {
                    this.Load3dsMaterial(reader, bl, chunk.length - 6);
                    break;
                }
                default: {
                    this.skipBytes(reader, chunk.length - 6);
                }
            }
            n2 -= chunk.length;
        }
        if (this.progress) {
            System.out.print("]");
        }
    }

    private void Load3dsMain(Reader reader, boolean bl, int n) {
        int n2 = n;
        if (this.progress) {
            System.out.print("{");
        }
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            switch (chunk.id) {
                case 15677: {
                    this.Load3dsMData(reader, bl, chunk.length - 6);
                    break;
                }
                default: {
                    this.skipBytes(reader, chunk.length - 6);
                }
            }
            n2 -= chunk.length;
        }
        if (this.progress) {
            System.out.println("}");
        }
    }

    private void Load3dsMaterial(Reader reader, boolean bl, int n) {
        if (this.progress) {
            System.out.print("(");
        }
        int n2 = n;
        String string = null;
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            switch (chunk.id) {
                case 40960: {
                    string = this.readString(reader, chunk.length - 6);
                    this.al.addAppearance(string);
                    break;
                }
                case 40976: {
                    this.al.setAmbient(string, this.getColor(reader, chunk.length - 6));
                    break;
                }
                case 40992: {
                    this.al.setDiffuse(string, this.getColor(reader, chunk.length - 6));
                    break;
                }
                case 41008: {
                    this.al.setSpecular(string, this.getColor(reader, chunk.length - 6));
                    break;
                }
                case 41024: {
                    this.al.setShininess(string, this.getPercent(reader, chunk.length - 6));
                    break;
                }
                case 41040: {
                    this.al.setTransparency(string, this.getPercent(reader, chunk.length - 6));
                    break;
                }
                case 41089: {
                    this.al.setTwoSided(string, true);
                    this.skipBytes(reader, chunk.length - 6);
                    break;
                }
                default: {
                    this.skipBytes(reader, chunk.length - 6);
                }
            }
            n2 -= chunk.length;
        }
        if (this.progress) {
            System.out.print(")");
        }
    }

    private void Load3dsMeshMatrix(Reader reader, boolean bl, int n, String string) {
        if (this.progress) {
            System.out.print(":");
        }
        int n2 = n;
        Mesh mesh = new Mesh();
        int n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            while (n4 < 3) {
                mesh.matrix[n3][n4] = this.readFloat(reader);
                ++n4;
            }
            ++n3;
        }
        n2 -= 48;
        this.ol.setMesh(string, mesh);
        if (this.progress) {
            System.out.print(":");
        }
    }

    private void Load3dsObject(Reader reader, boolean bl, int n) {
        if (this.progress) {
            System.out.print("<");
        }
        int n2 = n;
        String string = this.readString(reader);
        n2 -= string.length() + 1;
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            switch (chunk.id) {
                case 16640: {
                    this.Load3dsTriangleObject(reader, bl, chunk.length - 6, string);
                    break;
                }
                default: {
                    this.skipBytes(reader, chunk.length - 6);
                }
            }
            n2 -= chunk.length;
        }
        if (this.progress) {
            System.out.print(">");
        }
    }

    private void Load3dsPointArray(Reader reader, boolean bl, int n, String string) {
        if (this.progress) {
            System.out.print(":");
        }
        int n2 = this.readBytes(reader, 2);
        Point3f[] point3fArray = new Point3f[n2];
        int n3 = 0;
        while (n3 < n2) {
            Point3f point3f;
            point3fArray[n3] = point3f = new Point3f(this.readFloat(reader), this.readFloat(reader), this.readFloat(reader));
            ++n3;
        }
        this.ol.setPoint(string, point3fArray);
        if (this.progress) {
            System.out.print(":");
        }
    }

    private void Load3dsPointFlagArray(Reader reader, boolean bl, int n, String string) {
        if (this.progress) {
            System.out.print(":");
        }
        int n2 = this.readBytes(reader, 2);
        int n3 = n - 2;
        int[] nArray = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = this.readBytes(reader, 2);
            n3 -= 2;
            ++n4;
        }
        this.ol.setFlags(string, nArray);
        if (this.progress) {
            System.out.print(":");
        }
    }

    private void Load3dsTriangleObject(Reader reader, boolean bl, int n, String string) {
        if (this.progress) {
            System.out.print("/");
        }
        int n2 = n;
        while (n2 > 0) {
            Chunk chunk = this.readChunk(reader);
            switch (chunk.id) {
                case 16656: {
                    this.Load3dsPointArray(reader, bl, chunk.length - 6, string);
                    break;
                }
                case 16657: {
                    this.Load3dsPointFlagArray(reader, bl, chunk.length - 6, string);
                    break;
                }
                case 16672: {
                    this.Load3dsFaceArray(reader, bl, chunk.length - 6, string);
                    break;
                }
                case 16736: {
                    this.Load3dsMeshMatrix(reader, bl, chunk.length - 6, string);
                    break;
                }
                default: {
                    this.skipBytes(reader, chunk.length - 6);
                }
            }
            n2 -= chunk.length;
        }
        if (this.progress) {
            System.out.print("\\");
        }
    }

    private void PrintChunk(Chunk chunk, boolean bl) {
        int n = Integer.toHexString(chunk.id).length();
        System.out.print(" 0x");
        int n2 = 0;
        while (n2 < 4 - n) {
            System.out.print("0");
            ++n2;
        }
        System.out.print(String.valueOf(Integer.toHexString(chunk.id)) + ":" + chunk.length + (bl ? "\n" : " "));
    }

    private Color3f getColor(Reader reader, int n) {
        float[] fArray = new float[3];
        Chunk chunk = this.readChunk(reader);
        switch (chunk.id) {
            case 16: 
            case 18: {
                fArray[0] = this.readFloat(reader);
                fArray[1] = this.readFloat(reader);
                fArray[2] = this.readFloat(reader);
                this.readBytes(reader, chunk.length - 6 - 12);
                break;
            }
            case 17: 
            case 19: {
                fArray[0] = (float)this.readBytes(reader, 1) / 255.0f;
                fArray[1] = (float)this.readBytes(reader, 1) / 255.0f;
                fArray[2] = (float)this.readBytes(reader, 1) / 255.0f;
                this.readBytes(reader, chunk.length - 6 - 3);
                break;
            }
            default: {
                fArray[0] = 0.0f;
                fArray[1] = 0.0f;
                fArray[2] = 0.0f;
                this.readBytes(reader, n - 6);
            }
        }
        return new Color3f(fArray[0], fArray[1], fArray[2]);
    }

    private float getPercent(Reader reader, int n) {
        float f = 0.0f;
        Chunk chunk = this.readChunk(reader);
        switch (chunk.id) {
            case 48: {
                f = (float)this.readBytes(reader, 2) / 4095.0f;
                break;
            }
            case 49: {
                f = this.readFloat(reader);
                break;
            }
            default: {
                this.readBytes(reader, n - 6);
            }
        }
        return f;
    }

    private Chunk printChunk(Chunk chunk) {
        System.out.print(String.valueOf(Integer.toHexString(chunk.id)) + " -- " + chunk.length + ":");
        return chunk;
    }

    private int readBytes(Reader reader, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                n2 += reader.read() << 8 * n3;
            }
            catch (IOException iOException) {
                System.err.println("Error with file.\n" + iOException.toString());
                System.exit(1);
            }
            ++n3;
        }
        return n2;
    }

    private char readChar(Reader reader) {
        return (char)this.readBytes(reader, 1);
    }

    private Chunk readChunk(Reader reader) {
        int n = this.readBytes(reader, 2);
        int n2 = this.readBytes(reader, 4);
        return new Chunk(n, n2);
    }

    private float readFloat(Reader reader) {
        return Float.intBitsToFloat(this.readBytes(reader, 4));
    }

    private String readString(Reader reader) {
        String string = new String();
        char c = this.readChar(reader);
        while (c > '\u0000') {
            string = String.valueOf(string) + (char)c;
            c = this.readChar(reader);
        }
        return string;
    }

    private String readString(Reader reader, int n) {
        String string = new String();
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.readChar(reader);
            ++n2;
        }
        return string;
    }

    private void skipBytes(Reader reader, int n) {
        int n2 = 0;
        while (n2 < n) {
            try {
                reader.read();
            }
            catch (IOException iOException) {
                System.err.println("Error with file.\n" + iOException.toString());
                System.exit(1);
            }
            ++n2;
        }
    }
}

