/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.load3ds;

import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;

class AppearanceList {
    private Nodes Head = null;
    private Nodes Current = null;
    private final Color3f WHITE = new Color3f(1.0f, 1.0f, 1.0f);
    private final Color3f LTGRY = new Color3f(0.7f, 0.7f, 0.7f);
    private final Color3f DKGRY = new Color3f(0.3f, 0.3f, 0.3f);
    private final Color3f BLACK = new Color3f(0.0f, 0.0f, 0.0f);

    private Nodes FindName(String string) {
        if (string == null) {
            string = new String("");
        }
        if (this.Current != null && string.compareTo(this.Current.name) == 0) {
            return this.Current;
        }
        string = String.valueOf(string) + '\u0000';
        this.Current = this.Head;
        while (this.Current != null && string.compareTo(this.Current.name) != 0) {
            this.Current = this.Current.next;
        }
        if (this.Current == null) {
            this.addAppearance(string);
        }
        return this.Current;
    }

    public void PrintAppearance(String string) {
        Color3f color3f = new Color3f();
        Nodes nodes = this.FindName(string);
        System.out.print("\n" + nodes.name);
        Material material = nodes.app.getMaterial();
        material.getSpecularColor(color3f);
        System.out.print("\n (" + color3f.x + ", " + color3f.y + ", " + color3f.z + ")");
        material.getAmbientColor(color3f);
        System.out.print("\n (" + color3f.x + ", " + color3f.y + ", " + color3f.z + ")");
        material.getDiffuseColor(color3f);
        System.out.print("\n (" + color3f.x + ", " + color3f.y + ", " + color3f.z + ")");
        material.getEmissiveColor(color3f);
        System.out.print("\n (" + color3f.x + ", " + color3f.y + ", " + color3f.z + ")");
        System.out.print("\n " + material.getShininess() + " ---- " + nodes.app.getTransparencyAttributes().getTransparency());
        System.out.println();
    }

    public void PrintAppearanceList() {
        Color3f color3f = new Color3f();
        Nodes nodes = this.Head;
        while (nodes != null) {
            this.PrintAppearance(nodes.name);
            nodes = nodes.next;
        }
    }

    public Appearance addAppearance(String string) {
        Material material = new Material(this.LTGRY, this.BLACK, this.DKGRY, this.WHITE, 0.6f);
        material.setCapability(1);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes(4, 0.0f);
        transparencyAttributes.setCapability(3);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(7);
        polygonAttributes.setCullFace(0);
        polygonAttributes.setBackFaceNormalFlip(true);
        Appearance appearance = new Appearance();
        appearance.setCapability(15);
        appearance.setMaterial(material);
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setTransparencyAttributes(transparencyAttributes);
        this.Current = this.Head = new Nodes(appearance, string, this.Head);
        return this.Current.app;
    }

    public Appearance getAppearance(String string) {
        return this.FindName((String)string).app;
    }

    public Appearance setAmbient(String string, Color3f color3f) {
        this.FindName((String)string).app.getMaterial().setAmbientColor(color3f);
        return this.Current.app;
    }

    public Appearance setDiffuse(String string, Color3f color3f) {
        this.FindName((String)string).app.getMaterial().setDiffuseColor(color3f);
        return this.Current.app;
    }

    public Appearance setEmissive(String string, Color3f color3f) {
        this.FindName((String)string).app.getMaterial().setEmissiveColor(color3f);
        return this.Current.app;
    }

    public Appearance setShininess(String string, float f) {
        this.FindName((String)string).app.getMaterial().setShininess(f);
        return this.Current.app;
    }

    public Appearance setSpecular(String string, Color3f color3f) {
        this.FindName((String)string).app.getMaterial().setSpecularColor(color3f);
        return this.Current.app;
    }

    public Appearance setTransparency(String string, float f) {
        this.FindName((String)string).app.getTransparencyAttributes().setTransparency(f);
        return this.Current.app;
    }

    public Appearance setTwoSided(String string, boolean bl) {
        this.FindName((String)string).app.getPolygonAttributes().setCullFace(bl ? 0 : 2);
        if (bl) {
            this.FindName((String)string).app.getPolygonAttributes().setBackFaceNormalFlip(true);
        }
        return this.Current.app;
    }

    class Nodes {
        public Appearance app;
        public String name;
        public Nodes next;

        Nodes(Appearance appearance, String string, Nodes nodes) {
            this.app = appearance;
            this.name = string;
            this.next = nodes;
        }
    }
}

