/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.dxf;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class PointList {
    private Nodes Head = null;
    Nodes node = null;

    public void Done() {
        this.DoneHelper(this.Head);
    }

    private void DoneHelper(Nodes nodes) {
        if (nodes != null) {
            nodes.norm.normalize(nodes.norm);
            this.DoneHelper(nodes.Left);
            this.DoneHelper(nodes.Right);
        }
    }

    public void addPoint(Point3f point3f, Vector3f vector3f) {
        if (this.addPointHelper(this.Head, point3f, vector3f) == null) {
            this.Head = new Nodes(point3f, vector3f, null, null);
        }
    }

    private Nodes addPointHelper(Nodes nodes, Point3f point3f, Vector3f vector3f) {
        if (nodes != null) {
            switch (this.pCompare(point3f, nodes.point)) {
                case 0: {
                    nodes.norm = this.vAdd(nodes.norm, vector3f);
                    break;
                }
                case -1: {
                    if (this.addPointHelper(nodes.Left, point3f, vector3f) != null) break;
                    nodes.Left = new Nodes(point3f, vector3f, null, null);
                    break;
                }
                case 1: {
                    if (this.addPointHelper(nodes.Right, point3f, vector3f) != null) break;
                    nodes.Right = new Nodes(point3f, vector3f, null, null);
                    break;
                }
            }
        }
        return nodes;
    }

    private Nodes findPoint(Point3f point3f, Nodes nodes) {
        if (nodes == null) {
            return null;
        }
        switch (this.pCompare(point3f, nodes.point)) {
            case -1: {
                return this.findPoint(point3f, nodes.Left);
            }
            case 0: {
                return nodes;
            }
            case 1: {
                return this.findPoint(point3f, nodes.Right);
            }
        }
        return null;
    }

    public Vector3f getNormal(Point3f point3f) {
        if (this.node != null && this.pCompare(this.node.point, point3f) == 0) {
            return this.node.norm;
        }
        if (this.Head == null) {
            return null;
        }
        this.node = this.findPoint(point3f, this.Head);
        if (this.node != null) {
            return this.node.norm;
        }
        return null;
    }

    public Point3f getPoint(Point3f point3f) {
        if (this.node != null && this.pCompare(this.node.point, point3f) == 0) {
            return this.node.point;
        }
        if (this.Head == null) {
            return null;
        }
        this.node = this.findPoint(point3f, this.Head);
        if (this.node != null) {
            return this.node.point;
        }
        return null;
    }

    private int pCompare(Point3f point3f, Point3f point3f2) {
        if (point3f.x < point3f2.x) {
            return -1;
        }
        if (point3f2.x < point3f.x) {
            return 1;
        }
        if (point3f.y < point3f2.y) {
            return -1;
        }
        if (point3f2.y < point3f.y) {
            return 1;
        }
        if (point3f.z < point3f2.z) {
            return -1;
        }
        if (point3f2.z < point3f.z) {
            return 1;
        }
        return 0;
    }

    private Vector3f vAdd(Vector3f vector3f, Vector3f vector3f2) {
        Vector3f vector3f3 = new Vector3f();
        vector3f3.x = vector3f.x + vector3f2.x;
        vector3f3.y = vector3f.y + vector3f2.y;
        vector3f3.z = vector3f.z + vector3f2.z;
        return vector3f3;
    }

    class Nodes {
        Point3f point;
        Vector3f norm;
        Nodes Left;
        Nodes Right;

        public Nodes(Point3f point3f, Vector3f vector3f, Nodes nodes, Nodes nodes2) {
            this.point = point3f;
            this.norm = vector3f;
            this.Left = nodes;
            this.Right = nodes2;
        }
    }
}

