/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.loaders.dem;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import ncsa.util.ReaderTokenizer;

public class DEM {
    Appearance app = new Appearance();

    public DEM() {
        this.app.setCapability(15);
        Color3f color3f = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f color3f2 = new Color3f(0.0f, 0.0f, 0.0f);
        Color3f color3f3 = new Color3f(1.0f, 1.0f, 1.0f);
        Material material = new Material(color3f2, color3f, color3f, color3f3, 0.6f);
        material.setCapability(1);
        this.app.setMaterial(material);
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(7);
        polygonAttributes.setPolygonMode(2);
        this.app.setPolygonAttributes(polygonAttributes);
    }

    public BranchGroup LoadDEM(ReaderTokenizer readerTokenizer, boolean bl) {
        HeaderData headerData = this.readHeader(readerTokenizer, bl);
        int n = -2;
        int n2 = headerData.col;
        int n3 = 6;
        int n4 = 6;
        int[][] nArray = new int[n2][];
        int n5 = 0;
        while (n5 < n2) {
            if (bl) {
                System.err.print(String.valueOf(n5) + " ");
            }
            if (n5 % n3 == 0) {
                nArray[n5] = this.readRow(readerTokenizer, n);
            } else {
                this.readRow(readerTokenizer, 0);
            }
            ++n5;
        }
        n = nArray[0].length;
        Point3f[] point3fArray = new Point3f[(n - 1) / n3 * ((n2 - 1) / n4) * 6];
        int n6 = 0;
        float f = nArray[0][0];
        int n7 = 0;
        while (n7 < (n2 - 1) / n4) {
            if (bl) {
                System.err.print(String.valueOf(n7) + ":");
            }
            int n8 = 0;
            while (n8 < (n - 1) / n3) {
                point3fArray[n6 + 5] = new Point3f((float)((n8 + 1) * n3), (float)((n7 + 1) * n4), (float)nArray[(n7 + 1) * n4][(n8 + 1) * n3]);
                if ((n8 / n3 + n7 / n4) % 2 == 1) {
                    if (n8 > 0 && n7 > 0) {
                        point3fArray[n6] = point3fArray[n6 - ((n - 1) / n3 + 1) * 6 + 5];
                        point3fArray[n6 + 1] = point3fArray[n6 - (n - 1) / n3 * 6 + 5];
                        point3fArray[n6 + 2] = point3fArray[n6 - 6 + 5];
                    } else if (n8 > 0) {
                        point3fArray[n6] = new Point3f((float)(n8 * n3), (float)(n7 * n4), (float)nArray[n7 * n4][n8 * n3]);
                        point3fArray[n6 + 1] = new Point3f((float)((n8 + 1) * n3), (float)(n7 * n4), (float)nArray[n7 * n4][(n8 + 1) * n3]);
                        point3fArray[n6 + 2] = point3fArray[n6 - 6 + 5];
                    } else if (n7 > 0) {
                        point3fArray[n6] = new Point3f((float)(n8 * n3), (float)(n7 * n4), (float)nArray[n7 * n4][n8 * n3]);
                        point3fArray[n6 + 1] = point3fArray[n6 - (n - 1) / n3 * 6 + 5];
                        point3fArray[n6 + 2] = new Point3f((float)(n8 * n3), (float)((n7 + 1) * n4), (float)nArray[(n7 + 1) * n4][n8 * n3]);
                    } else {
                        point3fArray[n6] = new Point3f((float)(n8 * n3), (float)(n7 * n4), (float)nArray[n7 * n4][n8 * n3]);
                        point3fArray[n6 + 1] = new Point3f((float)((n8 + 1) * n3), (float)(n7 * n4), (float)nArray[n7 * n4][(n8 + 1) * n3]);
                        point3fArray[n6 + 2] = new Point3f((float)(n8 * n3), (float)((n7 + 1) * n4), (float)nArray[(n7 + 1) * n4][n8 * n3]);
                    }
                    point3fArray[n6 + 3] = point3fArray[n6 + 2];
                    point3fArray[n6 + 4] = point3fArray[n6 + 1];
                    f = this.min(f, point3fArray[n6].z, point3fArray[n6 + 1].z, point3fArray[n6 + 2].z, point3fArray[n6 + 5].z);
                } else {
                    if (n8 > 0 && n7 > 0) {
                        point3fArray[n6] = point3fArray[n6 - ((n - 1) / n3 + 1) * 6 + 5];
                        point3fArray[n6 + 1] = point3fArray[n6 - (n - 1) / n3 * 6 + 5];
                        point3fArray[n6 + 3] = point3fArray[n6 - 6 + 5];
                    } else if (n8 > 0) {
                        point3fArray[n6] = new Point3f((float)(n8 * n3), (float)(n7 * n4), (float)nArray[n7 * n4][n8 * n3]);
                        point3fArray[n6 + 1] = new Point3f((float)((n8 + 1) * n3), (float)(n7 * n4), (float)nArray[n7 * n4][(n8 + 1) * n3]);
                        point3fArray[n6 + 3] = point3fArray[n6 - 6 + 5];
                    } else if (n7 > 0) {
                        point3fArray[n6] = new Point3f((float)(n8 * n3), (float)(n7 * n4), (float)nArray[n7 * n4][n8 * n3]);
                        point3fArray[n6 + 1] = point3fArray[n6 - (n - 1) / n3 * 6 + 5];
                        point3fArray[n6 + 3] = new Point3f((float)(n8 * n3), (float)((n7 + 1) * n4), (float)nArray[(n7 + 1) * n4][n8 * n3]);
                    } else {
                        point3fArray[n6] = new Point3f((float)(n8 * n3), (float)(n7 * n4), (float)nArray[n7 * n4][n8 * n3]);
                        point3fArray[n6 + 1] = new Point3f((float)((n8 + 1) * n3), (float)(n7 * n4), (float)nArray[n7 * n4][(n8 + 1) * n3]);
                        point3fArray[n6 + 3] = new Point3f((float)(n8 * n3), (float)((n7 + 1) * n4), (float)nArray[(n7 + 1) * n4][n8 * n3]);
                    }
                    point3fArray[n6 + 4] = point3fArray[n6];
                    point3fArray[n6 + 2] = point3fArray[n6 + 5];
                    f = this.min(f, point3fArray[n6].z, point3fArray[n6 + 1].z, point3fArray[n6 + 3].z, point3fArray[n6 + 5].z);
                }
                n6 += 6;
                ++n8;
            }
            nArray[n7 * n4] = null;
            ++n7;
        }
        if (bl) {
            System.err.print("Ending...");
        }
        GeometryInfo geometryInfo = new GeometryInfo(1);
        geometryInfo.setCoordinates(point3fArray);
        point3fArray = null;
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.setCreaseAngle(Math.PI);
        normalGenerator.generateNormals(geometryInfo);
        BranchGroup branchGroup = new BranchGroup();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(0.0f, 0.0f, -(f + 150.0f)));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        transformGroup.addChild((Node)new Shape3D((Geometry)geometryInfo.getGeometryArray(), this.app));
        branchGroup.addChild((Node)transformGroup);
        if (bl) {
            System.err.println("...Done");
        }
        return branchGroup;
    }

    public Appearance getAppearance() {
        return this.app;
    }

    private float min(float f, float f2) {
        return f2 < f ? f2 : f;
    }

    private float min(float f, float f2, float f3, float f4, float f5) {
        return this.min(this.min(this.min(f, f2), this.min(f3, f4)), f5);
    }

    private String readBytes(ReaderTokenizer readerTokenizer, int n) {
        String string = new String();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = readerTokenizer.read();
            if (c == '\n') {
                return string;
            }
            if (c != ' ') {
                if (!bl) {
                    bl = true;
                }
                string = String.valueOf(string) + c;
            }
            ++n2;
        }
        if (!bl) {
            return null;
        }
        return string;
    }

    private HeaderData readHeader(ReaderTokenizer readerTokenizer, boolean bl) {
        HeaderData headerData = new HeaderData();
        this.readBytes(readerTokenizer, 858);
        headerData.col = Integer.parseInt(this.readBytes(readerTokenizer, 6));
        this.readBytes(readerTokenizer, 160);
        return headerData;
    }

    public int[] readRow(ReaderTokenizer readerTokenizer, int n) {
        readerTokenizer.nextToken();
        this.readBytes(readerTokenizer, 6);
        int n2 = Integer.parseInt(this.readBytes(readerTokenizer, 6));
        int n3 = Integer.parseInt(this.readBytes(readerTokenizer, 6));
        this.readBytes(readerTokenizer, 119);
        int n4 = n < 0 ? n2 : n;
        int[] nArray = new int[n4];
        int n5 = 0;
        while (n5 < n2) {
            String string = this.readBytes(readerTokenizer, 6);
            if (string == null) {
                string = this.readBytes(readerTokenizer, 4);
            }
            if (n5 < n4) {
                int n6 = string != null ? Integer.parseInt(string) - 140 : nArray[n5 - 1 < 0 ? 100 : n5 - 1];
                nArray[n5] = n6;
            }
            ++n5;
        }
        return nArray;
    }

    class HeaderData {
        int col;
    }
}

