/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d.application;

import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import ncsa.j3d.ui.PortfolioProperties;
import ncsa.j3d.ui.events.EventManager;
import ncsa.j3d.ui.tools.ToolManager;
import ncsa.j3d.ui.widgets.WidgetManager;

public class PortfolioApplication {
    protected Frame frame = null;
    public Canvas3D canvas = null;
    public WidgetManager widgetManager = null;

    public void configure(Canvas3D canvas3D, BranchGroup branchGroup, TransformGroup transformGroup) {
        this.widgetManager = new WidgetManager(canvas3D);
        ToolManager toolManager = ToolManager.instance();
        EventManager eventManager = EventManager.instance();
        if (canvas3D != null) {
            toolManager.setCanvas(canvas3D);
            this.widgetManager.setCanvas(canvas3D);
        }
        if (branchGroup != null) {
            toolManager.setBranchGroup(branchGroup);
            this.widgetManager.setBranchGroup(branchGroup);
            eventManager.setBranchGroup(branchGroup);
        }
        if (transformGroup != null) {
            toolManager.setViewTransform(transformGroup);
        }
        EventManager.instance().addEventReceiver(ToolManager.instance());
        EventManager.instance().loadInputSources();
        EventManager.instance().loadInputDevices();
        toolManager.loadTools();
    }

    public void configureStereo(View view) {
        String string = PortfolioProperties.instance().getProperty("Stereo");
        if (string != null && string.equalsIgnoreCase("true")) {
            PhysicalBody physicalBody = new PhysicalBody();
            physicalBody.setRightEyePosition(new Point3d(-0.010136, 0.0, 0.0));
            physicalBody.setLeftEyePosition(new Point3d(-0.007432, 0.0, 0.0));
            PhysicalEnvironment physicalEnvironment = new PhysicalEnvironment();
            view.setPhysicalBody(physicalBody);
            view.setPhysicalEnvironment(physicalEnvironment);
            String string2 = PortfolioProperties.instance().getProperty("Verbose");
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                System.out.println("Stero on.");
            }
        }
    }

    protected Node getGeometry() {
        return null;
    }

    public void launchFrame() {
        this.frame = new Frame("Portfolio");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.frame.addWindowListener(windowAdapter);
        this.canvas = new Canvas3D(null);
        SimpleUniverse simpleUniverse = new SimpleUniverse(this.canvas);
        View view = simpleUniverse.getViewer().getView();
        PhysicalEnvironment physicalEnvironment = view.getPhysicalEnvironment();
        physicalEnvironment.setSensorCount(100);
        view.setPhysicalEnvironment(physicalEnvironment);
        this.configureStereo(view);
        view.setBackClipDistance(1000000.0);
        ViewingPlatform viewingPlatform = simpleUniverse.getViewingPlatform();
        TransformGroup transformGroup = viewingPlatform.getViewPlatformTransform();
        Transform3D transform3D = new Transform3D();
        Vector3d vector3d = new Vector3d(5.0, 0.0, 30.0);
        transform3D.setTranslation(vector3d);
        transformGroup.setTransform(transform3D);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(13);
        branchGroup.setCapability(14);
        this.configure(this.canvas, branchGroup, transformGroup);
        Node node = this.getGeometry();
        if (node != null) {
            branchGroup.addChild(node);
        }
        simpleUniverse.addBranchGraph(branchGroup);
        this.canvas.setSize(300, 300);
        this.frame.add((Component)this.canvas);
        ((Component)this.frame).setSize(this.frame.getPreferredSize());
        ((Component)this.frame).setVisible(true);
    }
}

