/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class SimpleTransformGroup
extends TransformGroup {
    Vector3f initial = new Vector3f();
    protected float TRANSLATION = 0.05f;
    protected double ROTATION = Math.PI / 360;
    protected double SCALE = 0.01;
    protected Transform3D temp = new Transform3D();
    protected Transform3D transform = new Transform3D();
    protected Vector3d vector = new Vector3d();
    protected Vector3d zero = new Vector3d();

    public SimpleTransformGroup() {
        this.common();
    }

    public SimpleTransformGroup(Vector3f vector3f) {
        this.initial = new Vector3f(vector3f);
        this.common();
    }

    protected void common() {
        this.setCapability(18);
        this.setCapability(17);
        this.reset();
    }

    public Vector3d get() {
        Vector3d vector3d = new Vector3d();
        this.get(this.transform);
        this.transform.get(vector3d);
        return vector3d;
    }

    public void get(Transform3D transform3D) {
        this.getTransform(transform3D);
    }

    public void get(double[] dArray) {
        this.get(this.transform);
        this.transform.get(dArray);
    }

    public void move(Vector3d vector3d) {
        this.get(this.transform);
        this.transform.get(this.vector);
        this.vector.add((Tuple3d)vector3d);
        this.transform.setTranslation(this.vector);
        this.updateTransform(this.transform);
    }

    public void move(Vector3f vector3f) {
        this.move(new Vector3d(vector3f));
    }

    public void reset() {
        this.transform.set(this.initial);
        this.updateTransform(this.transform);
    }

    public void rotX(double d) {
        this.get(this.transform);
        this.temp.setIdentity();
        this.temp.rotX(d);
        this.transform.get(this.vector);
        this.transform.setTranslation(this.zero);
        this.transform.mul(this.temp, this.transform);
        this.transform.setTranslation(this.vector);
        this.updateTransform(this.transform);
    }

    public void rotY(double d) {
        this.get(this.transform);
        this.temp.setIdentity();
        this.temp.rotY(d);
        this.transform.get(this.vector);
        this.transform.setTranslation(this.zero);
        this.transform.mul(this.temp, this.transform);
        this.transform.setTranslation(this.vector);
        this.updateTransform(this.transform);
    }

    public void rotZ(double d) {
        this.get(this.transform);
        this.temp.setIdentity();
        this.temp.rotZ(d);
        this.transform.get(this.vector);
        this.transform.setTranslation(this.zero);
        this.transform.mul(this.temp, this.transform);
        this.transform.setTranslation(this.vector);
        this.updateTransform(this.transform);
    }

    public void scale(double d) {
        this.get(this.transform);
        this.temp.setIdentity();
        this.temp.set(d);
        this.transform.get(this.vector);
        this.transform.setTranslation(this.zero);
        this.transform.mul(this.temp, this.transform);
        this.transform.setTranslation(this.vector);
        this.updateTransform(this.transform);
    }

    public void scale(Vector3d vector3d) {
        this.getTransform(this.transform);
        this.temp.setIdentity();
        this.temp.setScale(vector3d);
        this.transform.get(this.vector);
        this.transform.setTranslation(this.zero);
        this.transform.mul(this.temp, this.transform);
        this.transform.setTranslation(this.vector);
        this.updateTransform(this.transform);
    }

    public void set(Transform3D transform3D) {
        this.updateTransform(transform3D);
    }

    public void set(Vector3d vector3d) {
        this.get(this.transform);
        this.transform.setTranslation(vector3d);
        this.updateTransform(this.transform);
    }

    public void set(Vector3d vector3d, double d, double d2, double d3) {
        this.transform.setIdentity();
        this.temp.setIdentity();
        this.temp.rotX(d);
        this.transform.mul(this.temp, this.transform);
        this.temp.setIdentity();
        this.temp.rotY(d2);
        this.transform.mul(this.temp, this.transform);
        this.temp.setIdentity();
        this.temp.rotZ(d3);
        this.transform.mul(this.temp, this.transform);
        this.transform.setTranslation(vector3d);
        this.updateTransform(this.transform);
    }

    public void set(SimpleTransformGroup simpleTransformGroup) {
        simpleTransformGroup.get(this.transform);
        this.updateTransform(this.transform);
    }

    public void set(double[] dArray) {
        if (dArray.length != 16) {
            return;
        }
        this.transform.set(dArray);
        this.updateTransform(this.transform);
    }

    protected void updateTransform(Transform3D transform3D) {
        this.setTransform(transform3D);
    }
}

