/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import ncsa.j3d.SimpleTransformGroup;

public class PickableTransformGroup
extends SimpleTransformGroup {
    protected static int count = 0;
    protected String name;

    public PickableTransformGroup() {
    }

    public PickableTransformGroup(Vector3f vector3f) {
        super(vector3f);
    }

    protected void common() {
        super.common();
        this.setCapability(1);
        this.name = new String("TransformGroup" + count++);
    }

    public static PickShape generatePickRay(int n, int n2, Canvas3D canvas3D) {
        PickRay pickRay = new PickRay();
        Transform3D transform3D = new Transform3D();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        canvas3D.getCenterEyeInImagePlate(point3d);
        canvas3D.getPixelLocationInImagePlate(n, n2, point3d2);
        canvas3D.getImagePlateToVworld(transform3D);
        transform3D.transform(point3d);
        transform3D.transform(point3d2);
        vector3d.sub((Tuple3d)point3d2, (Tuple3d)point3d);
        vector3d.normalize();
        pickRay.set(point3d, vector3d);
        return pickRay;
    }

    public String getName() {
        return this.name;
    }

    public static PickableTransformGroup selectNode(Canvas3D canvas3D, BranchGroup branchGroup, int n, int n2) {
        Node node = null;
        PickRay pickRay = (PickRay)PickableTransformGroup.generatePickRay(n, n2, canvas3D);
        SceneGraphPath sceneGraphPath = branchGroup.pickClosest((PickShape)pickRay);
        if (sceneGraphPath != null) {
            node = sceneGraphPath.getObject();
            if (node instanceof PickableTransformGroup) {
                return (PickableTransformGroup)node;
            }
            int n3 = 0;
            while (n3 < sceneGraphPath.nodeCount()) {
                node = sceneGraphPath.getNode(n3);
                if (node instanceof PickableTransformGroup) {
                    return (PickableTransformGroup)node;
                }
                ++n3;
            }
        }
        return null;
    }

    public void setName(String string) {
        this.name = string;
    }
}

