/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3f;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.TransformGroupCustomer;
import ncsa.net.MulticastHandler;

public class MulticastTransformGroup
extends PickableTransformGroup {
    MulticastHandler multiHandler = null;
    Transform3D transform = new Transform3D();

    public MulticastTransformGroup() {
    }

    public MulticastTransformGroup(Vector3f vector3f) {
        super(vector3f);
    }

    public void apply() {
        double[] dArray = new double[16];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.getTransform(this.transform);
            this.transform.get(dArray);
            int n = 0;
            while (n < 16) {
                dataOutputStream.writeDouble(dArray[n]);
                ++n;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.multiHandler.transmit(byArray, byArray.length);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return;
        }
    }

    public void endMulticast() {
        if (this.multiHandler != null) {
            this.multiHandler.end();
        }
        this.multiHandler = null;
    }

    public void startMulticast(String string, int n) {
        TransformGroupCustomer transformGroupCustomer = new TransformGroupCustomer(this);
        this.multiHandler = new MulticastHandler(string, n, transformGroupCustomer);
        this.multiHandler.begin();
    }
}

