/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d;

import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnCollisionEntry;
import javax.media.j3d.WakeupOnCollisionExit;
import javax.media.j3d.WakeupOnCollisionMovement;
import javax.vecmath.Point3d;
import ncsa.j3d.CollidableTransformGroup;

class CollisionDetector
extends Behavior {
    private WakeupCriterion criterion;
    CollidableTransformGroup gr;
    int value;

    public CollisionDetector(CollidableTransformGroup collidableTransformGroup, int n) {
        this.gr = collidableTransformGroup;
        this.value = n;
        this.setBounds();
        this.makeCriterion();
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.criterion);
    }

    public void makeCriterion() {
        switch (this.value) {
            case 0: {
                this.criterion = new WakeupOnCollisionEntry((Node)this.gr);
                break;
            }
            case 1: {
                this.criterion = new WakeupOnCollisionEntry((Node)this.gr);
                break;
            }
            case 2: {
                this.criterion = new WakeupOnCollisionMovement((Node)this.gr);
                break;
            }
            case 3: {
                this.criterion = new WakeupOnCollisionExit((Node)this.gr);
                break;
            }
        }
    }

    public void processStimulus(Enumeration enumeration) {
        this.gr.signal(this.value);
        this.wakeupOn((WakeupCondition)this.criterion);
    }

    protected void setBounds() {
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1.0);
        this.setSchedulingBounds((Bounds)boundingSphere);
    }
}

