/*
 * Decompiled with CFR 0.152.
 */
package ncsa.j3d;

import javax.vecmath.Vector3f;
import ncsa.j3d.CollisionDetector;
import ncsa.j3d.PickableTransformGroup;
import ncsa.j3d.ui.events.CollisionEvent;
import ncsa.j3d.ui.events.PortfolioEventReceiver;

public class CollidableTransformGroup
extends PickableTransformGroup {
    protected PortfolioEventReceiver receiver;
    protected CollisionDetector cdEnter;
    protected CollisionDetector cdMove;
    protected CollisionDetector cdExit;
    protected String description;

    public CollidableTransformGroup(Vector3f vector3f, PortfolioEventReceiver portfolioEventReceiver, String string) {
        super(vector3f);
        this.colsetup(portfolioEventReceiver, string);
    }

    public CollidableTransformGroup(PortfolioEventReceiver portfolioEventReceiver) {
        this.colsetup(portfolioEventReceiver, null);
    }

    public CollidableTransformGroup(PortfolioEventReceiver portfolioEventReceiver, String string) {
        this.colsetup(portfolioEventReceiver, string);
    }

    protected void colsetup(PortfolioEventReceiver portfolioEventReceiver, String string) {
        this.setCapability(0);
        this.receiver = portfolioEventReceiver;
        this.description = string;
        this.cdEnter = new CollisionDetector(this, 1);
        this.cdExit = new CollisionDetector(this, 3);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean setReceiver(Object object) {
        if (!(object instanceof PortfolioEventReceiver)) {
            return false;
        }
        this.receiver = (PortfolioEventReceiver)object;
        return true;
    }

    public void signal(int n) {
        if (this.receiver != null) {
            this.receiver.notify(new CollisionEvent((Object)this, n));
        }
    }
}

