/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.wand;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import ncsa.devices.NCSAInputDevice;
import ncsa.devices.wand.WandDevice;
import ncsa.j3d.ui.PortfolioProperties;

public class WandDriver
extends NCSAInputDevice
implements SerialPortEventListener {
    protected int[] buttons;
    protected float[] valuators;
    protected byte[] b = new byte[1];
    public int BUTTONS = 3;
    public int VALUATORS = 2;
    int numBytes = 0;
    byte[] buffer = new byte[30];
    SerialPort serialPort = null;
    InputStream inputStream = null;

    public int button(int n) {
        return this.buttons[n];
    }

    protected CommPortIdentifier getPortId(String string) {
        if (string == null) {
            return null;
        }
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier commPortIdentifier = (CommPortIdentifier)enumeration.nextElement();
            if (commPortIdentifier.getPortType() != 1 || !commPortIdentifier.getName().equals(string)) continue;
            return commPortIdentifier;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        WandDevice wandDevice = new WandDevice();
        wandDevice.initializePortfolioDevice("WandDriver");
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            wandDevice.pollAndProcessInput();
            System.out.print("\r" + wandDevice.button(0) + " " + wandDevice.button(1) + " " + wandDevice.button(2) + " " + wandDevice.valuator(0) + " " + wandDevice.valuator(1) + " " + "                          ");
        }
    }

    public void portfolioDeviceInitializing() {
        this.buttons = new int[this.BUTTONS];
        this.valuators = new float[this.VALUATORS];
        CommPortIdentifier commPortIdentifier = this.getPortId(PortfolioProperties.instance().getProperty(String.valueOf(this.name) + ".Port"));
        this.setup(commPortIdentifier);
    }

    public void process(byte by) {
        if (this.numBytes > 0) {
            this.buffer[this.numBytes++] = by;
            if (this.numBytes == 3) {
                this.valuators[this.buffer[0] & 7] = (float)((this.buffer[2] & 0x80) != 0 ? ((double)this.buffer[2] + 127.5) / 126.5 : ((double)this.buffer[2] - 127.5) / 127.5);
                this.numBytes = 0;
            }
        } else if (by >= 48 && by <= 56) {
            this.buffer[0] = by;
            this.numBytes = 1;
        } else if (by >= -40 && by <= -32) {
            this.buttons[by & 7] = 1;
        } else if (by >= -8 && by <= 0) {
            this.buttons[by & 7] = 0;
        }
    }

    public void serialEvent(SerialPortEvent serialPortEvent) {
        switch (serialPortEvent.getEventType()) {
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        this.inputStream.read(this.b);
                        this.process(this.b[0]);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("WandDriver.serialEvent");
                    System.out.println(iOException);
                }
                break;
            }
        }
    }

    protected void setup(CommPortIdentifier commPortIdentifier) {
        try {
            this.serialPort = (SerialPort)commPortIdentifier.open("WandDriver", 2000);
            this.inputStream = this.serialPort.getInputStream();
            this.serialPort.addEventListener((SerialPortEventListener)this);
            this.serialPort.notifyOnDataAvailable(true);
            this.serialPort.setSerialPortParams(9600, 8, 1, 0);
        }
        catch (IOException iOException) {
            System.out.println("WandDriver.setup(CommPortIdentifier)");
            System.out.println(iOException);
        }
        catch (PortInUseException portInUseException) {
            System.out.println("WandDriver.setup PORT IN USE");
            System.out.println((Object)portInUseException);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            System.out.println("WandDriver.setup");
            System.out.println((Object)unsupportedCommOperationException);
        }
        catch (TooManyListenersException tooManyListenersException) {
            System.out.println("WandDriver.setup");
            System.out.println(tooManyListenersException);
        }
    }

    public float valuator(int n) {
        return this.valuators[n];
    }
}

