/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.wand;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;

public class SensorDevice
implements InputDevice {
    protected Transform3D transform = new Transform3D();
    protected Vector3d vector = new Vector3d();
    protected Sensor sensor;
    protected SensorRead sensorRead;
    protected int[] buttons;
    private int processingMode = 5;
    protected String name;

    public SensorDevice(String string, int n) {
        this.name = string;
        this.buttons = new int[n];
        this.sensorRead = new SensorRead(n);
        this.sensor = new Sensor((InputDevice)this, 30, n);
    }

    public void close() {
    }

    public int getProcessingMode() {
        return this.processingMode;
    }

    public Sensor getSensor(int n) {
        return n == 0 ? this.sensor : null;
    }

    public int getSensorCount() {
        return 1;
    }

    public boolean initialize() {
        return true;
    }

    public void pollAndProcessInput() {
        this.sensorRead.setTime(System.currentTimeMillis());
        this.sensorRead.setButtons(this.buttons);
        this.transform.setTranslation(this.vector);
        this.sensorRead.set(this.transform);
        this.sensor.setNextSensorRead(this.sensorRead);
    }

    public void processStreamInput() {
    }

    public void set(Transform3D transform3D) {
        this.transform.set(transform3D);
    }

    public void set(int[] nArray) {
        if (this.buttons == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length && n < this.buttons.length) {
            this.buttons[n] = nArray[n];
            ++n;
        }
    }

    public void setNominalPositionAndOrientation() {
    }

    public void setProcessingMode(int n) {
    }
}

