/*
 * Decompiled with CFR 0.152.
 */
package ncsa.devices.virtual;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import ncsa.devices.virtual.RotationControls;

public class WheelControls
extends Canvas
implements RotationControls,
MouseMotionListener,
MouseListener {
    private static final int NONE = 0;
    private static final int SLIDE_Y = 1;
    private static final int SLIDE_X = 2;
    private static final int SLIDE_Z = 3;
    private int mode = 0;
    private Dimension size;
    private int thickness;
    private int diameter;
    private int space;
    private int pipSize;
    private int pipOffset;
    private int margin;
    private Polygon yPip;
    private Rectangle yBackClip;
    private Polygon xPip;
    private Rectangle xBackClip;
    private Polygon zPip;
    private Rectangle yArea;
    private Rectangle xArea;
    private Rectangle zArea;
    private Point oldMousePos = new Point();
    float yAngle = 0.0f;
    float xAngle = 0.0f;
    float zAngle = 0.0f;
    float yOrigAngle;
    float xOrigAngle;
    float zOrigAngle;
    float angleStep = 0.10471976f;

    public WheelControls() {
        this(0.0f, 0.0f, 0.0f);
    }

    public WheelControls(float f, float f2, float f3) {
        this.size = new Dimension(200, 200);
        this.xAngle = this.constrainAngle(f);
        this.yAngle = this.constrainAngle(f2);
        this.zAngle = this.constrainAngle(f3);
        this.yOrigAngle = this.yAngle;
        this.xOrigAngle = this.xAngle;
        this.zOrigAngle = this.zAngle;
        this.setSizes();
        this.yPip = new Polygon();
        this.yPip.addPoint(0, 0);
        this.yPip.addPoint(-this.pipSize / 2, this.pipSize);
        this.yPip.addPoint(this.pipSize / 2, this.pipSize);
        this.xPip = new Polygon();
        this.xPip.addPoint(0, 0);
        this.xPip.addPoint(this.pipSize, -this.pipSize / 2);
        this.xPip.addPoint(this.pipSize, this.pipSize / 2);
        this.zPip = new Polygon();
        this.zPip.addPoint(this.diameter / 2, this.pipOffset);
        this.zPip.addPoint(this.diameter / 2 - this.pipSize / 2, this.pipOffset - this.pipSize);
        this.zPip.addPoint(this.diameter / 2 + this.pipSize / 2, this.pipOffset - this.pipSize);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private float constrainAngle(float f) {
        if (f > (float)Math.PI * 2) {
            return f - (float)Math.PI * 2;
        }
        if (f < 0.0f) {
            return f + (float)Math.PI * 2;
        }
        return f;
    }

    private void drawXPip(Graphics2D graphics2D, float f) {
        AffineTransform affineTransform = new AffineTransform();
        int n = this.margin + this.diameter + this.space;
        int n2 = this.margin;
        Color color = graphics2D.getColor();
        int n3 = (double)f <= Math.PI ? n2 + this.diameter - (int)(Math.abs((double)f - 1.5707963267948966) / 1.5707963267948966 * (double)this.diameter / 2.0) : n2 + (int)(Math.abs((double)f - 4.71238898038469) / 1.5707963267948966 * (double)this.diameter / 2.0);
        if ((double)f < 1.5707963267948966 || (double)f > 4.71238898038469) {
            graphics2D.setColor(Color.red);
        } else {
            graphics2D.setColor(Color.black);
            graphics2D.setClip(this.xBackClip);
        }
        graphics2D.setXORMode(this.getBackground());
        affineTransform.setToTranslation(n + this.pipOffset, n3);
        graphics2D.setTransform(affineTransform);
        graphics2D.fillPolygon(this.xPip);
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(color);
        graphics2D.setPaintMode();
    }

    private void drawYPip(Graphics2D graphics2D, float f) {
        AffineTransform affineTransform = new AffineTransform();
        int n = this.margin;
        int n2 = this.margin + this.diameter + this.space;
        Color color = graphics2D.getColor();
        int n3 = (double)f <= Math.PI ? n + this.diameter - (int)(Math.abs((double)f - 1.5707963267948966) / 1.5707963267948966 * (double)this.diameter / 2.0) : n + (int)(Math.abs((double)f - 4.71238898038469) / 1.5707963267948966 * (double)this.diameter / 2.0);
        if ((double)f < 1.5707963267948966 || (double)f > 4.71238898038469) {
            graphics2D.setColor(Color.red);
        } else {
            graphics2D.setColor(Color.black);
            graphics2D.setClip(this.yBackClip);
        }
        graphics2D.setXORMode(this.getBackground());
        affineTransform.setToTranslation(n3, n2 + this.pipOffset);
        graphics2D.setTransform(affineTransform);
        graphics2D.fillPolygon(this.yPip);
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(color);
        graphics2D.setPaintMode();
    }

    private void drawZPip(Graphics2D graphics2D, float f) {
        AffineTransform affineTransform = new AffineTransform();
        Color color = graphics2D.getColor();
        affineTransform.translate(this.margin, this.margin);
        affineTransform.rotate(f, this.diameter / 2, this.diameter / 2);
        graphics2D.setXORMode(this.getBackground());
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(Color.red);
        graphics2D.fillPolygon(this.zPip);
        affineTransform.setToIdentity();
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(color);
        graphics2D.setPaintMode();
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public float getXAngle() {
        return this.xAngle;
    }

    public float getYAngle() {
        return this.yAngle;
    }

    public float getZAngle() {
        return this.zAngle;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = point.x - this.oldMousePos.x;
        int n2 = point.y - this.oldMousePos.y;
        switch (this.mode) {
            case 1: {
                this.drawYPip((Graphics2D)((Canvas)mouseEvent.getSource()).getGraphics(), this.yAngle);
                if (n < 0) {
                    this.yAngle -= this.angleStep;
                } else if (n > 0) {
                    this.yAngle += this.angleStep;
                }
                this.yAngle = this.constrainAngle(this.yAngle);
                this.drawYPip((Graphics2D)((Canvas)mouseEvent.getSource()).getGraphics(), this.yAngle);
                this.oldMousePos = point;
                break;
            }
            case 2: {
                this.drawXPip((Graphics2D)((Canvas)mouseEvent.getSource()).getGraphics(), this.xAngle);
                if (n2 < 0) {
                    this.xAngle -= this.angleStep;
                } else if (n2 > 0) {
                    this.xAngle += this.angleStep;
                }
                this.xAngle = this.constrainAngle(this.xAngle);
                this.drawXPip((Graphics2D)((Canvas)mouseEvent.getSource()).getGraphics(), this.xAngle);
                this.oldMousePos = point;
                break;
            }
            case 3: {
                this.drawZPip((Graphics2D)((Canvas)mouseEvent.getSource()).getGraphics(), this.zAngle);
                if (n < 0) {
                    this.zAngle -= this.angleStep;
                } else if (n > 0) {
                    this.zAngle += this.angleStep;
                }
                this.zAngle = this.constrainAngle(this.zAngle);
                this.drawZPip((Graphics2D)((Canvas)mouseEvent.getSource()).getGraphics(), this.zAngle);
                this.oldMousePos = point;
                break;
            }
            default: {
                throw new RuntimeException("Internal Error");
            }
            case 0: 
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.yArea.contains(mouseEvent.getPoint())) {
            this.mode = 1;
            this.oldMousePos = mouseEvent.getPoint();
        } else if (this.xArea.contains(mouseEvent.getPoint())) {
            this.mode = 2;
            this.oldMousePos = mouseEvent.getPoint();
        } else if (this.zArea.contains(mouseEvent.getPoint())) {
            this.mode = 3;
            this.oldMousePos = mouseEvent.getPoint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mode = 0;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics.drawOval(this.margin, this.margin, this.diameter, this.diameter);
        this.zArea = new Rectangle(this.margin, this.margin, this.diameter, this.diameter);
        this.drawZPip(graphics2D, this.zAngle);
        graphics.drawRect(this.margin, this.margin + this.diameter + this.space, this.diameter, this.thickness);
        this.yArea = new Rectangle(this.margin, this.margin + this.diameter + this.space, this.margin + this.diameter, this.thickness + this.pipOffset);
        this.yBackClip = new Rectangle(this.margin - this.thickness, this.margin + this.diameter + this.space + this.thickness, this.margin + this.diameter + this.thickness * 2, this.thickness);
        this.drawYPip(graphics2D, this.yAngle);
        graphics.drawRect(this.margin + this.diameter + this.space, this.margin, this.thickness, this.diameter);
        this.xArea = new Rectangle(this.margin + this.diameter + this.space, this.margin, this.thickness + this.pipOffset, this.margin + this.diameter);
        this.xBackClip = new Rectangle(this.margin + this.diameter + this.space + this.thickness, this.margin - this.thickness, this.thickness, this.margin + this.diameter + this.thickness * 2);
        this.drawXPip(graphics2D, this.xAngle);
    }

    public void reset() {
        this.drawYPip((Graphics2D)this.getGraphics(), this.yAngle);
        this.yAngle = this.yOrigAngle;
        this.drawYPip((Graphics2D)this.getGraphics(), this.yAngle);
        this.drawXPip((Graphics2D)this.getGraphics(), this.xAngle);
        this.xAngle = this.xOrigAngle;
        this.drawXPip((Graphics2D)this.getGraphics(), this.xAngle);
        this.drawZPip((Graphics2D)this.getGraphics(), this.zAngle);
        this.zAngle = this.zOrigAngle;
        this.drawZPip((Graphics2D)this.getGraphics(), this.zAngle);
        this.oldMousePos.setLocation(0, 0);
    }

    public void setSize(Dimension dimension) {
        this.size.width = dimension.width < dimension.height ? (this.size.height = dimension.width) : (this.size.height = dimension.height);
        this.setSizes();
    }

    private void setSizes() {
        this.margin = 10;
        int n = this.size.width - this.margin * 2;
        this.thickness = n * 7 / 100;
        this.diameter = n * 70 / 100;
        this.space = n * 10 / 100;
        this.pipSize = n * 7 / 100;
        this.pipOffset = this.thickness / 2;
    }
}

